/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class RetnTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "retn");
        if (instruction.getOperands().size() > 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a retn instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize nextSize = TranslationHelpers.getNextSize(archSize);
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String returnAddress = environment.getNextVariableString();
        String adjustedStack = environment.getNextVariableString();
        instructions.add(ReilHelpers.createLdm(offset, archSize, "esp", archSize, returnAddress));
        List<? extends IOperandTree> operands = instruction.getOperands();
        String stackMovement = operands.size() == 0 ? String.valueOf(archSize.getByteSize()) : String.valueOf((long)archSize.getByteSize() + Long.valueOf(Helpers.getLeafValue(operands.get(0).getRootNode())));
        instructions.add(ReilHelpers.createAdd(offset + 1L, archSize, "esp", archSize, stackMovement, nextSize, adjustedStack));
        instructions.add(ReilHelpers.createAnd(offset + 2L, nextSize, adjustedStack, nextSize, truncateMask, archSize, "esp"));
        instructions.add(ReilHelpers.createJcc(offset + 3L, archSize, "1", archSize, returnAddress, new String[0]));
    }
}

