/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class RclTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "rcl");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a rcl instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize sourceSize = sourceResult.getSize();
        OperandSize targetSize = targetResult.getSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(targetSize);
        String sourceRegister = sourceResult.getRegister();
        String targetRegister = targetResult.getRegister();
        String os2 = String.valueOf(targetSize.getBitSize());
        String rotateMask = environment.getNextVariableString();
        String rotateMaskZero = environment.getNextVariableString();
        String rotateMaskLessOne = environment.getNextVariableString();
        String rotateMaskOne = environment.getNextVariableString();
        String shiftedCf = environment.getNextVariableString();
        String realOp1 = environment.getNextVariableString();
        String shrValue = environment.getNextVariableString();
        String shredResult = environment.getNextVariableString();
        String shledResult = environment.getNextVariableString();
        String result = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        String msbResult = environment.getNextVariableString();
        String tempOf = environment.getNextVariableString();
        String tempOfLsb = environment.getNextVariableString();
        String carryMask = String.valueOf(Helpers.getCarryMask(targetSize));
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(targetSize));
        String maskSize = String.valueOf(TranslationHelpers.getAllBitsMask(targetSize));
        String modVal = String.valueOf(targetSize.getBitSize() + 1);
        String shiftMsbLsb = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(targetSize));
        int linesBefore = instructions.size();
        instructions.add(ReilHelpers.createMod(offset, sourceSize, sourceRegister, sourceSize, os2, OperandSize.BYTE, rotateMask));
        instructions.add(ReilHelpers.createBisz(offset + 1L, OperandSize.BYTE, rotateMask, OperandSize.BYTE, rotateMaskZero));
        instructions.add(ReilHelpers.createSub(offset + 2L, OperandSize.BYTE, rotateMask, OperandSize.BYTE, "1", OperandSize.BYTE, rotateMaskLessOne));
        instructions.add(ReilHelpers.createBisz(offset + 3L, OperandSize.BYTE, rotateMaskLessOne, OperandSize.BYTE, rotateMaskOne));
        instructions.add(ReilHelpers.createBsh(offset + 4L, OperandSize.BYTE, "CF", sourceSize, os2, resultSize, shiftedCf));
        instructions.add(ReilHelpers.createOr(offset + 5L, targetSize, targetRegister, resultSize, shiftedCf, resultSize, realOp1));
        instructions.add(ReilHelpers.createBsh(offset + 6L, resultSize, realOp1, OperandSize.BYTE, rotateMask, resultSize, shledResult));
        String string2 = String.valueOf(modVal);
        instructions.add(ReilHelpers.createAdd(offset + 7L, OperandSize.BYTE, string2.length() != 0 ? "-".concat(string2) : new String("-"), OperandSize.BYTE, rotateMask, OperandSize.BYTE, shrValue));
        instructions.add(ReilHelpers.createBsh(offset + 8L, resultSize, realOp1, OperandSize.BYTE, shrValue, resultSize, shredResult));
        instructions.add(ReilHelpers.createOr(offset + 9L, resultSize, shledResult, resultSize, shredResult, resultSize, result));
        instructions.add(ReilHelpers.createAnd(offset + 10L, resultSize, result, targetSize, maskSize, targetSize, truncatedResult));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 20);
        instructions.add(ReilHelpers.createJcc(offset + 11L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 12L, resultSize, result, resultSize, carryMask, resultSize, msbResult));
        String string3 = String.valueOf(os2);
        instructions.add(ReilHelpers.createBsh(offset + 13L, resultSize, msbResult, resultSize, string3.length() != 0 ? "-".concat(string3) : new String("-"), OperandSize.BYTE, "CF"));
        String jmpGoal2 = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 17);
        instructions.add(ReilHelpers.createJcc(offset + 14L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createUndef(offset + 15L, OperandSize.BYTE, "OF"));
        String jmpGoal3 = String.format("%d.%d", instruction.getAddress().toLong(), linesBefore + 20);
        instructions.add(ReilHelpers.createJcc(offset + 16L, OperandSize.BYTE, rotateMaskZero, OperandSize.ADDRESS, jmpGoal3, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset + 17L, sourceSize, truncatedResult, sourceSize, msbMask, sourceSize, tempOf));
        instructions.add(ReilHelpers.createBsh(offset + 18L, sourceSize, tempOf, sourceSize, shiftMsbLsb, OperandSize.BYTE, tempOfLsb));
        instructions.add(ReilHelpers.createBsh(offset + 19L, OperandSize.BYTE, tempOfLsb, OperandSize.BYTE, "CF", OperandSize.BYTE, "CF"));
        Helpers.writeBack(environment, offset + 20L, targetOperand, truncatedResult, targetResult.getSize(), targetResult.getAddress(), targetResult.getType(), instructions);
    }
}

