/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class NotTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "not");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not an not instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset, operand, true);
        instructions.addAll(result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String operandRegister = result.getRegister();
        OperandSize size = result.getSize();
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(size));
        String xorResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, size, operandRegister, size, truncateMask, size, xorResult));
        Helpers.writeBack(environment, offset + 1L, operand, xorResult, size, result.getAddress(), result.getType(), instructions);
    }
}

