/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class MovsxTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "movsx");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a movsx instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, operands.get(1), true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String sourceOperand = sourceResult.getRegister();
        String destinationOperand = Helpers.getLeafValue(operands.get(0).getRootNode());
        OperandSize destSize = Helpers.getRegisterSize(destinationOperand);
        OperandSize sourceSize = sourceResult.getSize();
        TranslationResult extendedSign = Helpers.extendSign(environment, offset, sourceOperand, sourceSize, destSize);
        instructions.addAll(extendedSign.getInstructions());
        offset = baseOffset + (long)instructions.size();
        if (destSize == environment.getArchitectureSize()) {
            instructions.add(ReilHelpers.createStr(offset, destSize, extendedSign.getRegister(), destSize, destinationOperand));
        } else {
            Helpers.moveAndMask(environment, offset, extendedSign.getSize(), extendedSign.getRegister(), destinationOperand, instructions);
        }
    }
}

