/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class LoopneTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "loopne");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a loopne instruction (invalid number of operands)");
        }
        long baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(archSize);
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String loopTarget = Helpers.getLeafValue(operands.get(0).getRootNode());
        String tempEcx = environment.getNextVariableString();
        String ecxZero = environment.getNextVariableString();
        String ecxNotZero = environment.getNextVariableString();
        String zfZero = environment.getNextVariableString();
        String condition = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(baseOffset, archSize, "ecx", archSize, "1", archSize, tempEcx));
        instructions.add(ReilHelpers.createAnd(baseOffset + 1L, resultSize, tempEcx, archSize, truncateMask, archSize, "ecx"));
        instructions.add(ReilHelpers.createBisz(baseOffset + 2L, archSize, "ecx", OperandSize.BYTE, ecxZero));
        instructions.add(ReilHelpers.createBisz(baseOffset + 3L, OperandSize.BYTE, ecxZero, OperandSize.BYTE, ecxNotZero));
        instructions.add(ReilHelpers.createBisz(baseOffset + 4L, OperandSize.BYTE, "ZF", OperandSize.BYTE, zfZero));
        instructions.add(ReilHelpers.createAnd(baseOffset + 5L, OperandSize.BYTE, ecxNotZero, OperandSize.BYTE, zfZero, OperandSize.BYTE, condition));
        instructions.add(ReilHelpers.createJcc(baseOffset + 5L, OperandSize.BYTE, condition, archSize, loopTarget, new String[0]));
    }
}

