/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.OperandType;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.TranslationResultType;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class LeaTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "lea");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a lea instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        IOperandTree sourceOperand = operands.get(1);
        String destination = Helpers.getLeafValue(targetOperand.getRootNode());
        OperandSize size = Helpers.getOperandSize(targetOperand);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, false);
        String sourceRegister = sourceResult.getRegister() != null ? sourceResult.getRegister() : sourceResult.getAddress();
        sourceResult.getType();
        List<ReilInstruction> sourceInstructions = sourceResult.getInstructions();
        instructions.addAll(sourceInstructions);
        offset = baseOffset + (long)instructions.size();
        if (size == OperandSize.WORD) {
            OperandType operandType = OperandType.getOperandType(sourceRegister);
            if (operandType == OperandType.INTEGER_LITERAL) {
                sourceRegister = String.valueOf(Long.valueOf(sourceRegister) & 0xFFFFL);
            } else if (operandType == OperandType.REGISTER) {
                String truncatedValue = environment.getNextVariableString();
                OperandSize registerSize = sourceInstructions.size() == 0 ? Helpers.getRegisterSize(sourceRegister) : environment.getArchitectureSize();
                instructions.add(ReilHelpers.createAnd(offset, registerSize, sourceRegister, OperandSize.WORD, "65535", OperandSize.WORD, truncatedValue));
                ++offset;
                sourceRegister = truncatedValue;
            } else assert (false);
            Helpers.writeBack(environment, offset, targetOperand, sourceRegister, size, null, TranslationResultType.REGISTER, instructions);
        } else if (size == OperandSize.DWORD) {
            instructions.add(ReilHelpers.createStr(offset, size, sourceRegister, size, destination));
        } else assert (false);
    }
}

