/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class LahfTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "lahf");
        if (instruction.getOperands().size() != 0) {
            throw new InternalTranslationException("Error: Argument instruction is not a lahf instruction (invalid number of operands)");
        }
        long baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize archSize = environment.getArchitectureSize();
        String clearedEax = environment.getNextVariableString();
        String shiftedSf = environment.getNextVariableString();
        String clearedEaxSf = environment.getNextVariableString();
        String shiftedZf = environment.getNextVariableString();
        String clearedEaxZf = environment.getNextVariableString();
        String shiftedAf = environment.getNextVariableString();
        String clearedEaxAf = environment.getNextVariableString();
        String shiftedPf = environment.getNextVariableString();
        String clearedEaxPf = environment.getNextVariableString();
        String shiftedCf = environment.getNextVariableString();
        String clearedEaxCf = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset, archSize, "eax", archSize, "4294902015", archSize, clearedEax));
        instructions.add(ReilHelpers.createBsh(baseOffset + 1L, OperandSize.BYTE, "SF", OperandSize.BYTE, "15", OperandSize.WORD, shiftedSf));
        instructions.add(ReilHelpers.createOr(baseOffset + 2L, archSize, clearedEax, OperandSize.WORD, shiftedSf, archSize, clearedEaxSf));
        instructions.add(ReilHelpers.createBsh(baseOffset + 3L, OperandSize.BYTE, "ZF", OperandSize.BYTE, "14", OperandSize.WORD, shiftedZf));
        instructions.add(ReilHelpers.createOr(baseOffset + 4L, archSize, clearedEaxSf, OperandSize.WORD, shiftedZf, archSize, clearedEaxZf));
        instructions.add(ReilHelpers.createBsh(baseOffset + 5L, OperandSize.BYTE, "AF", OperandSize.BYTE, "12", OperandSize.WORD, shiftedAf));
        instructions.add(ReilHelpers.createOr(baseOffset + 6L, archSize, clearedEaxZf, OperandSize.WORD, shiftedAf, archSize, clearedEaxAf));
        instructions.add(ReilHelpers.createBsh(baseOffset + 7L, OperandSize.BYTE, "PF", OperandSize.BYTE, "10", OperandSize.WORD, shiftedPf));
        instructions.add(ReilHelpers.createOr(baseOffset + 8L, archSize, clearedEaxAf, OperandSize.WORD, shiftedPf, archSize, clearedEaxPf));
        instructions.add(ReilHelpers.createBsh(baseOffset + 9L, OperandSize.BYTE, "CF", OperandSize.BYTE, "8", OperandSize.WORD, shiftedCf));
        instructions.add(ReilHelpers.createOr(baseOffset + 10L, archSize, clearedEaxPf, OperandSize.WORD, shiftedCf, archSize, clearedEaxCf));
        instructions.add(ReilHelpers.createOr(baseOffset + 11L, archSize, clearedEaxCf, archSize, "512", archSize, "eax"));
    }
}

