/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.reil.translators.x86.IConditionGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class JccTranslator
implements IInstructionTranslator {
    private final IConditionGenerator conditionGenerator;

    public JccTranslator(IConditionGenerator conditionGenerator) {
        this.conditionGenerator = Preconditions.checkNotNull(conditionGenerator, "Error: Argument conditionGenerator can't be null");
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        Preconditions.checkArgument(instruction.getOperands().size() == 1, "Error: Argument instruction is not a conditional jump instruction (invalid number of operands)");
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset, operand, true);
        instructions.addAll(result.getInstructions());
        String jumpTarget = result.getRegister();
        offset = baseOffset + (long)instructions.size();
        Pair<OperandSize, String> condition = this.conditionGenerator.generate(environment, offset, instructions);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createJcc(offset, condition.first(), condition.second(), environment.getArchitectureSize(), jumpTarget, new String[0]));
    }
}

