/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class IncTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "inc");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not an inc instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree operand = instruction.getOperands().get(0);
        TranslationResult result = Helpers.translateOperand(environment, offset, operand, true);
        instructions.addAll(result.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String loadedRegister = result.getRegister();
        OperandSize registerSize = result.getSize();
        OperandSize nextSize = TranslationHelpers.getNextSize(registerSize);
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(registerSize));
        String shiftMsbLsbMask = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(registerSize));
        String truncMask = String.valueOf(TranslationHelpers.getAllBitsMask(registerSize));
        String maskedMsb = environment.getNextVariableString();
        String addResult = environment.getNextVariableString();
        String maskedMsbResult = environment.getNextVariableString();
        String maskedMsbNeg = environment.getNextVariableString();
        String tempOF = environment.getNextVariableString();
        String truncatedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, registerSize, loadedRegister, registerSize, msbMask, registerSize, maskedMsb));
        instructions.add(ReilHelpers.createAdd(offset + 1L, registerSize, loadedRegister, registerSize, "1", nextSize, addResult));
        instructions.add(ReilHelpers.createAnd(offset + 2L, nextSize, addResult, registerSize, msbMask, registerSize, maskedMsbResult));
        instructions.add(ReilHelpers.createBsh(offset + 3L, registerSize, maskedMsbResult, registerSize, shiftMsbLsbMask, OperandSize.BYTE, "SF"));
        instructions.add(ReilHelpers.createXor(offset + 4L, registerSize, maskedMsb, registerSize, msbMask, registerSize, maskedMsbNeg));
        instructions.add(ReilHelpers.createAnd(offset + 5L, registerSize, maskedMsbResult, registerSize, maskedMsbNeg, registerSize, tempOF));
        instructions.add(ReilHelpers.createBsh(offset + 6L, registerSize, tempOF, registerSize, shiftMsbLsbMask, OperandSize.BYTE, "OF"));
        instructions.add(ReilHelpers.createAnd(offset + 7L, nextSize, addResult, registerSize, truncMask, registerSize, truncatedResult));
        instructions.add(ReilHelpers.createBisz(offset + 8L, registerSize, truncatedResult, OperandSize.BYTE, "ZF"));
        Helpers.writeBack(environment, offset + 9L, operand, truncatedResult, registerSize, result.getAddress(), result.getType(), instructions);
    }
}

