/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class IdivTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "idiv");
        if (instruction.getOperands().size() != 1) {
            throw new InternalTranslationException("Error: Argument instruction is not a idiv instruction (invalid number of operands)");
        }
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree divisorOperand = operands.get(0);
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        OperandSize size = Helpers.getOperandSize(operands.get(0));
        TranslationResult resultDividend = Helpers.loadFirstDivOperand(environment, offset, size);
        instructions.addAll(resultDividend.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String dividend = resultDividend.getRegister();
        TranslationResult resultDivisor = Helpers.translateOperand(environment, offset, divisorOperand, true);
        instructions.addAll(resultDivisor.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String divisor = resultDivisor.getRegister();
        Pair<String, String> absDividend = Helpers.generateAbs(environment, offset, dividend, size, instructions);
        offset = baseOffset + (long)instructions.size();
        Pair<String, String> absDivisor = Helpers.generateAbs(environment, offset, divisor, size, instructions);
        offset = baseOffset + (long)instructions.size();
        String divResult = environment.getNextVariableString();
        String modResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createDiv(offset, size, absDividend.second(), size, absDivisor.second(), size, divResult));
        instructions.add(ReilHelpers.createMod(offset + 1L, size, absDividend.second(), size, absDivisor.second(), size, modResult));
        String xoredSigns = environment.getNextVariableString();
        String toggleMask = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset + 2L, size, absDividend.first(), size, absDividend.second(), size, xoredSigns));
        instructions.add(ReilHelpers.createSub(offset + 3L, size, "0", size, xoredSigns, size, toggleMask));
        String decDivResult = environment.getNextVariableString();
        String realDivResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset + 4L, size, divResult, size, xoredSigns, size, decDivResult));
        instructions.add(ReilHelpers.createXor(offset + 5L, size, decDivResult, size, toggleMask, size, realDivResult));
        String modToggleMask = environment.getNextVariableString();
        String decModResult = environment.getNextVariableString();
        String realModResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset + 6L, size, "0", size, absDividend.first(), size, modToggleMask));
        instructions.add(ReilHelpers.createSub(offset + 7L, size, modResult, size, absDividend.first(), size, decModResult));
        instructions.add(ReilHelpers.createXor(offset + 8L, size, decModResult, size, modToggleMask, size, realModResult));
        instructions.addAll(Helpers.writeDivResult(environment, offset + 9L, realDivResult, realModResult, size));
    }
}

