/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class Cmpxchg8bTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "cmpxchg8b");
        Preconditions.checkArgument(instruction.getOperands().size() == 1, "Error: Argument instruction is not a cmpxchg8b instruction (invalid number of operands)");
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree targetOperand = operands.get(0);
        TranslationResult firstResult = Helpers.translateOperand(environment, offset, targetOperand, false);
        instructions.addAll(firstResult.getInstructions());
        String loadResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createLdm(baseOffset + (long)instructions.size(), OperandSize.DWORD, firstResult.getAddress(), OperandSize.QWORD, loadResult));
        String combinedEdxEax = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset + (long)instructions.size(), OperandSize.DWORD, "edx", OperandSize.DWORD, "32", OperandSize.QWORD, combinedEdxEax));
        instructions.add(ReilHelpers.createOr(baseOffset + (long)instructions.size(), OperandSize.QWORD, "eax", OperandSize.QWORD, combinedEdxEax, OperandSize.QWORD, combinedEdxEax));
        String comparisonResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(baseOffset + (long)instructions.size(), OperandSize.QWORD, combinedEdxEax, OperandSize.QWORD, loadResult, OperandSize.QWORD, comparisonResult));
        instructions.add(ReilHelpers.createBisz(baseOffset + (long)instructions.size(), OperandSize.QWORD, comparisonResult, OperandSize.BYTE, "ZF"));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 4);
        instructions.add(ReilHelpers.createJcc(baseOffset + (long)instructions.size(), OperandSize.BYTE, "ZF", OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAnd(baseOffset + (long)instructions.size(), OperandSize.QWORD, loadResult, OperandSize.QWORD, String.valueOf(TranslationHelpers.getAllBitsMask(OperandSize.DWORD)), OperandSize.DWORD, "eax"));
        instructions.add(ReilHelpers.createBsh(baseOffset + (long)instructions.size(), OperandSize.QWORD, loadResult, OperandSize.DWORD, "-32", OperandSize.DWORD, "edx"));
        String jmpGoal2 = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 4);
        instructions.add(ReilHelpers.createJcc(baseOffset + (long)instructions.size(), OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createBsh(baseOffset + (long)instructions.size(), OperandSize.DWORD, "ecx", OperandSize.DWORD, "32", OperandSize.QWORD, combinedEdxEax));
        instructions.add(ReilHelpers.createOr(baseOffset + (long)instructions.size(), OperandSize.QWORD, "ebx", OperandSize.QWORD, combinedEdxEax, OperandSize.QWORD, combinedEdxEax));
        instructions.add(ReilHelpers.createStm(baseOffset + (long)instructions.size(), OperandSize.QWORD, combinedEdxEax, OperandSize.DWORD, firstResult.getAddress()));
        instructions.add(ReilHelpers.createNop(baseOffset + (long)instructions.size()));
    }
}

