/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.reil.translators.x86.IStringInstructionGenerator;
import com.google.security.zynamics.zylib.disassembly.CAddress;
import java.util.List;

public class CmpsGenerator
implements IStringInstructionGenerator {
    @Override
    public void generate(ITranslationEnvironment environment, long baseOffset, OperandSize operandSize, List<ReilInstruction> instructions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        long offset = baseOffset;
        int previousInstructions = (int)(baseOffset % 256L);
        OperandSize archSize = environment.getArchitectureSize();
        OperandSize resultSize = TranslationHelpers.getNextSize(archSize);
        String ediChange = String.valueOf(operandSize.getByteSize());
        String truncateMask = String.valueOf(TranslationHelpers.getAllBitsMask(archSize));
        String firstVar = environment.getNextVariableString();
        String secondVar = environment.getNextVariableString();
        String tempEsi1 = environment.getNextVariableString();
        String tempEdi1 = environment.getNextVariableString();
        String tempEsi2 = environment.getNextVariableString();
        String tempEdi2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createLdm(offset, archSize, "esi", operandSize, firstVar));
        instructions.add(ReilHelpers.createLdm(offset + 1L, archSize, "edi", operandSize, secondVar));
        String jmpGoal = String.format("%d.%d", ReilHelpers.toNativeAddress(new CAddress(baseOffset)).toLong(), previousInstructions + 8);
        instructions.add(ReilHelpers.createJcc(offset + 2L, OperandSize.BYTE, "DF", OperandSize.ADDRESS, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAdd(offset + 3L, archSize, "esi", archSize, ediChange, resultSize, tempEsi1));
        instructions.add(ReilHelpers.createAnd(offset + 4L, resultSize, tempEsi1, resultSize, truncateMask, archSize, "esi"));
        instructions.add(ReilHelpers.createAdd(offset + 5L, archSize, "edi", archSize, ediChange, resultSize, tempEdi1));
        instructions.add(ReilHelpers.createAnd(offset + 6L, resultSize, tempEdi1, resultSize, truncateMask, archSize, "edi"));
        String jmpGoal2 = String.format("%d.%d", ReilHelpers.toNativeAddress(new CAddress(baseOffset)).toLong(), previousInstructions + 12);
        instructions.add(ReilHelpers.createJcc(offset + 7L, OperandSize.BYTE, "1", OperandSize.ADDRESS, jmpGoal2, new String[0]));
        instructions.add(ReilHelpers.createSub(offset + 8L, archSize, "esi", archSize, ediChange, resultSize, tempEsi2));
        instructions.add(ReilHelpers.createAnd(offset + 9L, resultSize, tempEsi2, resultSize, truncateMask, archSize, "esi"));
        instructions.add(ReilHelpers.createSub(offset + 10L, archSize, "edi", archSize, ediChange, resultSize, tempEdi2));
        instructions.add(ReilHelpers.createAnd(offset + 11L, resultSize, tempEdi2, resultSize, truncateMask, archSize, "edi"));
        Helpers.generateSub(environment, offset + 12L, operandSize, firstVar, secondVar, instructions);
    }
}

