/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class BtsTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "bts");
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a bts instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree targetOperand = instruction.getOperands().get(0);
        IOperandTree sourceOperand = instruction.getOperands().get(1);
        TranslationResult targetResult = Helpers.translateOperand(environment, offset, targetOperand, true);
        instructions.addAll(targetResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        String negatedIndex = environment.getNextVariableString();
        String shiftedTarget = environment.getNextVariableString();
        instructions.add(ReilHelpers.createSub(offset++, OperandSize.BYTE, "0", sourceResult.getSize(), sourceResult.getRegister(), OperandSize.WORD, negatedIndex));
        instructions.add(ReilHelpers.createBsh(offset++, targetResult.getSize(), targetResult.getRegister(), OperandSize.BYTE, negatedIndex, targetResult.getSize(), shiftedTarget));
        instructions.add(ReilHelpers.createAnd(offset++, targetResult.getSize(), shiftedTarget, OperandSize.BYTE, "1", OperandSize.BYTE, "CF"));
        String shiftedIndex = environment.getNextVariableString();
        String andedResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(offset++, OperandSize.BYTE, "1", sourceResult.getSize(), sourceResult.getRegister(), targetResult.getSize(), shiftedIndex));
        instructions.add(ReilHelpers.createOr(offset++, targetResult.getSize(), targetResult.getRegister(), targetResult.getSize(), shiftedIndex, targetResult.getSize(), andedResult));
        Helpers.writeBack(environment, offset++, targetOperand, andedResult, targetResult.getSize(), targetResult.getAddress(), targetResult.getType(), instructions);
    }
}

