/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.x86;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.TranslationResult;
import com.google.security.zynamics.reil.translators.x86.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.ArrayList;
import java.util.List;

public class BsfBsrTranslatorCommon {
    public static void translateBsfOrBsr(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, boolean translateBsf) throws InternalTranslationException {
        long baseOffset;
        if (instruction.getOperands().size() != 2) {
            throw new InternalTranslationException("Error: Argument instruction is not a bsr/bsf instruction (invalid number of operands)");
        }
        long offset = baseOffset = instruction.getAddress().toLong() * 256L;
        IOperandTree targetOperand = instruction.getOperands().get(0);
        IOperandTree sourceOperand = instruction.getOperands().get(1);
        TranslationResult sourceResult = Helpers.translateOperand(environment, offset, sourceOperand, true);
        instructions.addAll(sourceResult.getInstructions());
        offset = baseOffset + (long)instructions.size();
        OperandSize sourceSize = sourceResult.getSize();
        ArrayList tempInstructions = new ArrayList();
        String targetRegister = Helpers.getLeafValue(targetOperand.getRootNode());
        String labelNotZero = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 4);
        String labelLoopStart = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 7);
        String labelLoopEnd = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 12);
        String labelEnd = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + tempInstructions.size() + 12);
        instructions.add(ReilHelpers.createJcc(offset++, sourceSize, sourceResult.getRegister(), OperandSize.ADDRESS, labelNotZero, new String[0]));
        instructions.add(ReilHelpers.createStr(offset++, OperandSize.BYTE, "1", OperandSize.BYTE, "ZF"));
        instructions.add(ReilHelpers.createUndef(offset++, environment.getArchitectureSize(), targetRegister));
        instructions.add(ReilHelpers.createJcc(offset++, OperandSize.BYTE, "1", OperandSize.ADDRESS, labelEnd, new String[0]));
        String counter = environment.getNextVariableString();
        String shiftedValue = environment.getNextVariableString();
        String isolatedMsb = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(offset++, OperandSize.BYTE, "0", OperandSize.BYTE, "ZF"));
        instructions.add(ReilHelpers.createStr(offset++, sourceSize, sourceResult.getRegister(), sourceSize, shiftedValue));
        if (translateBsf) {
            instructions.add(ReilHelpers.createStr(offset++, OperandSize.BYTE, "0", OperandSize.BYTE, counter));
            instructions.add(ReilHelpers.createAnd(offset++, sourceSize, shiftedValue, sourceSize, "1", sourceSize, isolatedMsb));
        } else {
            instructions.add(ReilHelpers.createStr(offset++, OperandSize.BYTE, "31", OperandSize.BYTE, counter));
            instructions.add(ReilHelpers.createAnd(offset++, sourceSize, shiftedValue, sourceSize, String.valueOf(TranslationHelpers.getMsbMask(sourceSize)), sourceSize, isolatedMsb));
        }
        instructions.add(ReilHelpers.createJcc(offset++, sourceSize, isolatedMsb, OperandSize.ADDRESS, labelLoopEnd, new String[0]));
        if (translateBsf) {
            instructions.add(ReilHelpers.createAdd(offset++, OperandSize.BYTE, counter, OperandSize.BYTE, "1", OperandSize.BYTE, counter));
            instructions.add(ReilHelpers.createBsh(offset++, sourceSize, shiftedValue, sourceSize, "-1", sourceSize, shiftedValue));
        } else {
            instructions.add(ReilHelpers.createSub(offset++, OperandSize.BYTE, counter, OperandSize.BYTE, "1", OperandSize.BYTE, counter));
            instructions.add(ReilHelpers.createBsh(offset++, sourceSize, shiftedValue, sourceSize, "1", sourceSize, shiftedValue));
        }
        instructions.add(ReilHelpers.createJcc(offset++, OperandSize.BYTE, "1", OperandSize.ADDRESS, labelLoopStart, new String[0]));
        instructions.add(ReilHelpers.createStr(offset++, OperandSize.DWORD, counter, OperandSize.DWORD, targetRegister));
        instructions.add(ReilHelpers.createNop(offset++));
    }
}

