/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.reil;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperand;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ITranslationExtension;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.IAddress;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class TranslatorREIL<InstructionType extends IInstruction>
implements ITranslator<InstructionType> {
    private ReilOperand convert(IOperandTree operandTree) {
        if (operandTree.getRootNode().getChildren().get(0).getValue().equals(" ")) {
            return ReilHelpers.createOperand(OperandSize.EMPTY, "");
        }
        return ReilHelpers.createOperand(OperandSize.sizeStringToValue(operandTree.getRootNode().getValue()), operandTree.getRootNode().getChildren().get(0).getValue());
    }

    @Override
    public List<ReilInstruction> translate(ITranslationEnvironment environment, InstructionType instruction, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        IAddress offset = ReilHelpers.toReilAddress(instruction.getAddress());
        String mnemonic = instruction.getMnemonic();
        ReilOperand firstOperand = this.convert(instruction.getOperands().get(0));
        ReilOperand secondOperand = this.convert(instruction.getOperands().get(1));
        ReilOperand thirdOperand = this.convert(instruction.getOperands().get(2));
        return Lists.newArrayList(new ReilInstruction(offset, mnemonic, firstOperand, secondOperand, thirdOperand));
    }
}

