/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class XorGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String firstOperand, String secondOperand, boolean setCr, boolean setOverflow, boolean isNeg, boolean isEqv) throws InternalTranslationException {
        String eqvTmp;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String crTemp = setCr ? environment.getNextVariableString() : null;
        String negTemp = isNeg ? environment.getNextVariableString() : null;
        String negTemp2 = isNeg ? environment.getNextVariableString() : null;
        String overflowTmp = setOverflow ? environment.getNextVariableString() : null;
        String string2 = eqvTmp = isEqv ? environment.getNextVariableString() : null;
        if (isNeg) {
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, secondOperand, OperandSize.DWORD, negTemp));
            instructions.add(ReilHelpers.createAdd(baseOffset++, OperandSize.DWORD, negTemp, OperandSize.BYTE, "1", OperandSize.QWORD, negTemp2));
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, negTemp2, OperandSize.DWORD, "4294967295", OperandSize.DWORD, targetRegister));
            if (setOverflow) {
                instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.DWORD, String.valueOf(0x80000000L), OperandSize.DWORD, overflowTmp));
                instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, overflowTmp, OperandSize.WORD, "XEROV"));
                instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.WORD, "XERSO", OperandSize.DWORD, "XEROV", OperandSize.WORD, "XERSO"));
            }
        } else if (isEqv) {
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, secondOperand, OperandSize.DWORD, eqvTmp));
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, eqvTmp, OperandSize.DWORD, String.valueOf(0xFFFFFFFFL), OperandSize.DWORD, targetRegister));
        } else {
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, secondOperand, OperandSize.DWORD, targetRegister));
        }
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

