/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.ReilOperandNode;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class StoreGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, OperandSize opSize, boolean isIndexed, boolean withUpdate, boolean storeMultiple, boolean isByteReverse) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode sourceRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceRegisterOperand1 = null;
        IOperandTreeNode sourceRegisterOperand2 = null;
        if (instruction.getOperands().size() == 2 && instruction.getOperands().get(1).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().size() != 2) {
            sourceRegisterOperand1 = new ReilOperandNode("0", ExpressionType.IMMEDIATE_INTEGER);
            sourceRegisterOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        } else {
            sourceRegisterOperand1 = isIndexed ? instruction.getOperands().get(1).getRootNode().getChildren().get(0) : instruction.getOperands().get(1).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().get(0);
            sourceRegisterOperand2 = isIndexed ? instruction.getOperands().get(2).getRootNode().getChildren().get(0) : instruction.getOperands().get(1).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().get(1);
        }
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        String effectiveAddress = environment.getNextVariableString();
        String tmpEffectiveAddress = environment.getNextVariableString();
        String tmpData = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegisterOperand1.getValue(), dw, sourceRegisterOperand2.getValue(), qw, tmpEffectiveAddress));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpEffectiveAddress, dw, String.valueOf(0xFFFFFFFFL), dw, effectiveAddress));
        if (opSize == bt2) {
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister.getValue(), dw, String.valueOf(255L), bt2, tmpData));
            instructions.add(ReilHelpers.createStm(baseOffset++, bt2, tmpData, dw, effectiveAddress));
        } else if (opSize == wd) {
            if (isByteReverse) {
                String tmpHighByte = environment.getNextVariableString();
                String tmpLowByte = environment.getNextVariableString();
                String tmpHighByteShifted = environment.getNextVariableString();
                String tmpLowByteShifted = environment.getNextVariableString();
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, sourceRegister.getValue(), dw, String.valueOf(255L), dw, tmpLowByte));
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, sourceRegister.getValue(), dw, String.valueOf(65280L), dw, tmpHighByte));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpLowByte, bt2, String.valueOf(8L), dw, tmpLowByteShifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpHighByte, bt2, String.valueOf(-8L), dw, tmpHighByteShifted));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpHighByteShifted, dw, tmpLowByteShifted, dw, tmpData));
            } else {
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister.getValue(), dw, String.valueOf(65535L), wd, tmpData));
            }
            instructions.add(ReilHelpers.createStm(baseOffset++, wd, tmpData, dw, effectiveAddress));
        } else if (opSize == dw) {
            if (!isByteReverse && !storeMultiple) {
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, sourceRegister.getValue(), dw, String.valueOf(0xFFFFFFFFL), dw, tmpData));
                instructions.add(ReilHelpers.createStm(baseOffset++, dw, tmpData, dw, effectiveAddress));
            } else if (storeMultiple && !isByteReverse) {
                int index = Helpers.getRegisterIndex(sourceRegister.getValue());
                while (index <= 31) {
                    long l2 = baseOffset++;
                    int tmpLowByte = index++;
                    instructions.add(ReilHelpers.createStm(l2, dw, new StringBuilder(13).append("%r").append(tmpLowByte).toString(), dw, effectiveAddress));
                    instructions.add(ReilHelpers.createAdd(baseOffset++, dw, effectiveAddress, bt2, String.valueOf(4L), dw, effectiveAddress));
                }
            } else if (!storeMultiple && isByteReverse) {
                String tmpByte1 = environment.getNextVariableString();
                String tmpByte2 = environment.getNextVariableString();
                String tmpByte3 = environment.getNextVariableString();
                String tmpByte4 = environment.getNextVariableString();
                String tmpByte1Shifted = environment.getNextVariableString();
                String tmpByte2Shifted = environment.getNextVariableString();
                String tmpByte3Shifted = environment.getNextVariableString();
                String tmpByte4Shifted = environment.getNextVariableString();
                String tmpTargetValue1 = environment.getNextVariableString();
                String tmpTargetValue2 = environment.getNextVariableString();
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, sourceRegister.getValue(), dw, String.valueOf(255L), dw, tmpByte1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, sourceRegister.getValue(), dw, String.valueOf(65280L), dw, tmpByte2));
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, sourceRegister.getValue(), dw, String.valueOf(0xFF0000L), dw, tmpByte3));
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, sourceRegister.getValue(), dw, String.valueOf(0xFF000000L), dw, tmpByte4));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte1, bt2, String.valueOf(24L), dw, tmpByte1Shifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte2, bt2, String.valueOf(8L), dw, tmpByte2Shifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte3, bt2, String.valueOf(-8L), dw, tmpByte3Shifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte4, bt2, String.valueOf(-24L), dw, tmpByte4Shifted));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpByte1Shifted, dw, tmpByte2Shifted, dw, tmpTargetValue1));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpByte3Shifted, dw, tmpByte4Shifted, dw, tmpTargetValue2));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpTargetValue1, dw, tmpTargetValue2, dw, tmpData));
                instructions.add(ReilHelpers.createStm(baseOffset++, dw, tmpData, dw, effectiveAddress));
            }
        }
        if (withUpdate) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, effectiveAddress, dw, sourceRegisterOperand1.getValue()));
        }
    }
}

