/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class SignExtendGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, OperandSize opSize, boolean setCr) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        if (opSize == bt2) {
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister, dw, String.valueOf(128), dw, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(255L), dw, tmpVar2));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, String.valueOf(128L), dw, targetRegister));
        } else {
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister, dw, String.valueOf(32768), dw, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(65535L), dw, tmpVar2));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, String.valueOf(32768L), dw, targetRegister));
        }
        if (setCr) {
            String crTemp = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

