/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class RlwinmGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, boolean isSimplified, boolean setCr) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand1 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand2 = instruction.getOperands().size() >= 4 ? instruction.getOperands().get(3).getRootNode().getChildren().get(0) : null;
        IOperandTreeNode integerOperand3 = instruction.getOperands().size() == 5 ? instruction.getOperands().get(4).getRootNode().getChildren().get(0) : null;
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        String SH = "";
        String MB = "";
        String ME = "";
        String crTemp = environment.getNextVariableString();
        String rotateVar1 = environment.getNextVariableString();
        String rotateVar2 = environment.getNextVariableString();
        String rotateVar3 = environment.getNextVariableString();
        String rotateVar4 = environment.getNextVariableString();
        if (isSimplified) {
            if (instruction.getMnemonic().equals("extlwi") || instruction.getMnemonic().equals("extlwi.")) {
                SH = integerOperand2.getValue();
                MB = String.valueOf(0L);
                ME = String.valueOf(Integer.decode(integerOperand1.getValue()) - 1);
            } else if (instruction.getMnemonic().equals("extrwi") || instruction.getMnemonic().equals("extrwi.")) {
                SH = String.valueOf(Integer.decode(integerOperand2.getValue()) + Integer.decode(integerOperand1.getValue()));
                MB = String.valueOf(32 - Integer.decode(integerOperand1.getValue()));
                ME = String.valueOf(31L);
            } else if (instruction.getMnemonic().equals("rotlwi") || instruction.getMnemonic().equals("rotlwi.")) {
                SH = integerOperand1.getValue();
                MB = String.valueOf(0L);
                ME = String.valueOf(31L);
            } else if (instruction.getMnemonic().equals("rotrwi") || instruction.getMnemonic().equals("rotrwi.")) {
                SH = String.valueOf(32 - Integer.decode(integerOperand1.getValue()));
                MB = String.valueOf(0L);
                ME = String.valueOf(31L);
            } else if (instruction.getMnemonic().equals("slwi") || instruction.getMnemonic().equals("slwi.")) {
                SH = integerOperand1.getValue();
                MB = String.valueOf(0L);
                ME = String.valueOf(31 - Integer.decode(integerOperand1.getValue()));
            } else if (instruction.getMnemonic().equals("srwi") || instruction.getMnemonic().equals("srwi.")) {
                SH = String.valueOf(32 - Integer.decode(integerOperand1.getValue()));
                MB = integerOperand1.getValue();
                ME = String.valueOf(31L);
            } else if (instruction.getMnemonic().equals("clrlwi") || instruction.getMnemonic().equals("clrlwi.")) {
                SH = String.valueOf(0L);
                MB = integerOperand1.getValue();
                ME = String.valueOf(31L);
            } else if (instruction.getMnemonic().equals("clrrwi") || instruction.getMnemonic().equals("clrrwi.")) {
                SH = String.valueOf(0L);
                MB = String.valueOf(0L);
                ME = String.valueOf(31 - Integer.decode(integerOperand1.getValue()));
            } else if (instruction.getMnemonic().equals("clrlslwi") || instruction.getMnemonic().equals("clrlslwi.")) {
                SH = integerOperand2.getValue();
                MB = String.valueOf(Integer.decode(integerOperand1.getValue()) - Integer.decode(integerOperand2.getValue()));
                ME = String.valueOf(31 - Integer.decode(integerOperand2.getValue()));
            } else {
                SH = integerOperand1.getValue();
                MB = integerOperand2.getValue();
            }
        } else {
            SH = integerOperand1.getValue();
            MB = integerOperand2.getValue();
            ME = integerOperand3.getValue();
        }
        String normalMask = instruction.getOperands().size() == 4 && !isSimplified ? integerOperand2.getValue() : Helpers.getRotateMask(MB, ME);
        OperandSize dw = OperandSize.DWORD;
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, SH, dw, rotateVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-(32 - Integer.decode(SH))), dw, rotateVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, rotateVar1, dw, rotateVar2, dw, rotateVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, rotateVar3, dw, String.valueOf(0xFFFFFFFFL), dw, rotateVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, rotateVar4, dw, normalMask, dw, targetRegister));
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

