/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class RlwimiGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, boolean isSimplified, boolean setCr) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand1 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        IOperandTreeNode integerOperand2 = instruction.getOperands().size() >= 4 ? instruction.getOperands().get(3).getRootNode().getChildren().get(0) : null;
        IOperandTreeNode integerOperand3 = instruction.getOperands().size() == 5 ? instruction.getOperands().get(4).getRootNode().getChildren().get(0) : null;
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        String SH = "";
        String MB = "";
        String ME = "";
        if (isSimplified) {
            if (instruction.getMnemonic().equals("inslwi") || instruction.getMnemonic().equals("inslwi.")) {
                SH = String.valueOf(32 - Integer.decode(integerOperand2.getValue()));
                MB = integerOperand2.getValue();
                ME = String.valueOf(Integer.decode(integerOperand1.getValue()) + Integer.decode(integerOperand2.getValue()) - 1);
            } else if (instruction.getMnemonic().equals("insrwi") || instruction.getMnemonic().equals("insrwi.")) {
                SH = String.valueOf(32 - (Integer.decode(integerOperand2.getValue()) + Integer.decode(integerOperand1.getValue())));
                MB = integerOperand2.getValue();
                ME = String.valueOf(Integer.decode(integerOperand2.getValue()) + Integer.decode(integerOperand1.getValue()) - 1);
            } else {
                SH = integerOperand1.getValue();
                MB = integerOperand2.getValue();
            }
        } else {
            SH = integerOperand1.getValue();
            MB = integerOperand2.getValue();
            ME = integerOperand3.getValue();
        }
        String crTemp = environment.getNextVariableString();
        String rotateVar1 = environment.getNextVariableString();
        String rotateVar2 = environment.getNextVariableString();
        String rotateVar3 = environment.getNextVariableString();
        String rotateVar4 = environment.getNextVariableString();
        String normalMask = instruction.getOperands().size() == 4 && !isSimplified ? integerOperand2.getValue() : Helpers.getRotateMask(MB, ME);
        String inverseMask = environment.getNextVariableString();
        String maskVar1 = environment.getNextVariableString();
        String maskVar2 = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, SH, dw, rotateVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister, dw, String.valueOf(-(32 - Integer.decode(SH))), dw, rotateVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, rotateVar1, dw, rotateVar2, dw, rotateVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, rotateVar3, dw, String.valueOf(0xFFFFFFFFL), dw, rotateVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, rotateVar4, dw, normalMask, dw, maskVar1));
        instructions.add(ReilHelpers.createXor(baseOffset++, dw, normalMask, dw, String.valueOf(0xFFFFFFFFL), dw, inverseMask));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, targetRegister, dw, inverseMask, dw, maskVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dw, maskVar1, dw, maskVar2, dw, targetRegister));
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

