/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class MulGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String firstOperand, String secondOperand, boolean setCr, boolean isSigned, boolean isHigh, boolean setOv) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String tmpMulVar = environment.getNextVariableString();
        String crTemp = setCr ? environment.getNextVariableString() : null;
        String firstComplementVar = environment.getNextVariableString();
        String secondComplementVar = environment.getNextVariableString();
        String firstMSB = environment.getNextVariableString();
        String secondMSB = environment.getNextVariableString();
        String firstOneComplement = environment.getNextVariableString();
        String secondOneComplement = environment.getNextVariableString();
        String firstTwoComplement = environment.getNextVariableString();
        String secondTwoComplement = environment.getNextVariableString();
        String shiftedTmpMulVar = environment.getNextVariableString();
        String resultOneComplement = environment.getNextVariableString();
        String firstComplementVar2 = environment.getNextVariableString();
        String secondComplementVar2 = environment.getNextVariableString();
        String finalFirstComplement = environment.getNextVariableString();
        String finalSecondComplement = environment.getNextVariableString();
        String finalComplement = environment.getNextVariableString();
        String finalMSB = environment.getNextVariableString();
        String tmpResult = environment.getNextVariableString();
        String checkOverflowVar = environment.getNextVariableString();
        String overflowTmp = environment.getNextVariableString();
        OperandSize qw = OperandSize.QWORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        if (isSigned) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, String.valueOf(0xFFFFFFFFL), dw, firstComplementVar));
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, String.valueOf(0xFFFFFFFFL), dw, secondComplementVar));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, firstOperand, bt2, String.valueOf(-31L), bt2, firstMSB));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, secondOperand, bt2, String.valueOf(-31L), bt2, secondMSB));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, firstMSB, bt2, firstComplementVar2));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, secondMSB, bt2, secondComplementVar2));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstComplementVar, bt2, firstComplementVar2, dw, finalFirstComplement));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, finalFirstComplement, dw, String.valueOf(0xFFFFFFFFL), dw, finalFirstComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, secondComplementVar, bt2, secondComplementVar2, dw, finalSecondComplement));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, finalSecondComplement, dw, String.valueOf(0xFFFFFFFFL), dw, finalSecondComplement));
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, firstMSB, bt2, secondMSB, bt2, finalMSB));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, finalFirstComplement, dw, finalSecondComplement, dw, finalComplement));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, firstOperand, dw, finalComplement, dw, firstOneComplement));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, secondOperand, dw, finalComplement, dw, secondOneComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstOneComplement, bt2, finalMSB, dw, firstTwoComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, secondOneComplement, bt2, finalMSB, dw, secondTwoComplement));
            instructions.add(ReilHelpers.createMul(baseOffset++, dw, firstTwoComplement, dw, secondTwoComplement, qw, tmpMulVar));
            if (isHigh) {
                instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpMulVar, dw, String.valueOf(-32L), dw, shiftedTmpMulVar));
            } else {
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpMulVar, dw, String.valueOf(0xFFFFFFFFL), dw, shiftedTmpMulVar));
            }
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, shiftedTmpMulVar, dw, finalComplement, dw, resultOneComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, resultOneComplement, bt2, finalMSB, dw, tmpResult));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpResult, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        } else {
            instructions.add(ReilHelpers.createMul(baseOffset++, dw, firstOperand, dw, secondOperand, qw, tmpMulVar));
            if (isHigh) {
                instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpMulVar, dw, String.valueOf(-32L), dw, shiftedTmpMulVar));
            } else {
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpMulVar, dw, String.valueOf(0xFFFFFFFFL), dw, shiftedTmpMulVar));
            }
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, shiftedTmpMulVar, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        }
        if (setOv) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpMulVar, bt2, String.valueOf(-32L), dw, checkOverflowVar));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, checkOverflowVar, bt2, overflowTmp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, overflowTmp, bt2, "XEROV"));
            instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "XERSO", bt2, "XEROV", bt2, "XERSO"));
        }
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, OperandSize.WORD, "-31", bt2, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "CR0EQ", bt2, "CR0LT", bt2, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, crTemp, bt2, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, bt2, "XERSO", bt2, "CR0SO"));
        }
    }
}

