/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class LoadGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, OperandSize opSize, boolean isIndexed, boolean withUpdate, boolean isAlgebraic, boolean loadMultiple, boolean isByteReverse) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode targetRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode sourceRegisterOperand1 = isIndexed ? instruction.getOperands().get(1).getRootNode().getChildren().get(0) : instruction.getOperands().get(1).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().get(0);
        IOperandTreeNode sourceRegisterOperand2 = isIndexed ? instruction.getOperands().get(2).getRootNode().getChildren().get(0) : instruction.getOperands().get(1).getRootNode().getChildren().get(0).getChildren().get(0).getChildren().get(1);
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        String effectiveAddress = environment.getNextVariableString();
        String tmpEffectiveAddress = environment.getNextVariableString();
        String tmpDataWord = environment.getNextVariableString();
        String tmpDataByte = environment.getNextVariableString();
        String tmpDataDWord = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegisterOperand1.getValue(), dw, sourceRegisterOperand2.getValue(), qw, tmpEffectiveAddress));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpEffectiveAddress, dw, String.valueOf(0xFFFFFFFFL), dw, effectiveAddress));
        if (opSize == bt2) {
            instructions.add(ReilHelpers.createLdm(baseOffset++, dw, effectiveAddress, bt2, tmpDataByte));
            instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpDataByte, dw, String.valueOf(255L), dw, targetRegister.getValue()));
        } else if (opSize == wd) {
            instructions.add(ReilHelpers.createLdm(baseOffset++, dw, effectiveAddress, wd, tmpDataWord));
            if (!isAlgebraic && !isByteReverse) {
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, tmpDataWord, dw, String.valueOf(65535L), dw, targetRegister.getValue()));
            } else if (isAlgebraic && !isByteReverse) {
                String tmpAlgebraic1 = environment.getNextVariableString();
                String tmpAlgebraic2 = environment.getNextVariableString();
                String tmpAlgebraic3 = environment.getNextVariableString();
                String tmpAlgebraic4 = environment.getNextVariableString();
                String tmpAlgebraic5 = environment.getNextVariableString();
                String tmpAlgebraic6 = environment.getNextVariableString();
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, tmpDataWord, dw, String.valueOf(65535L), dw, tmpAlgebraic6));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpAlgebraic6, wd, String.valueOf(-15L), dw, tmpAlgebraic1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpAlgebraic1, dw, String.valueOf(1L), dw, tmpAlgebraic2));
                instructions.add(ReilHelpers.createBisz(baseOffset++, dw, tmpAlgebraic2, dw, tmpAlgebraic3));
                instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpAlgebraic3, dw, String.valueOf(0xFFFFFFFFL), dw, tmpAlgebraic4));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpAlgebraic4, dw, String.valueOf(0xFFFF0000L), dw, tmpAlgebraic5));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpAlgebraic5, dw, tmpAlgebraic6, dw, targetRegister.getValue()));
            } else if (!isAlgebraic && isByteReverse) {
                String tmpHighByte = environment.getNextVariableString();
                String tmpHighByteShifted = environment.getNextVariableString();
                String tmpLowByte = environment.getNextVariableString();
                String tmpLowByteShifted = environment.getNextVariableString();
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, tmpDataWord, dw, String.valueOf(255L), dw, tmpLowByte));
                instructions.add(ReilHelpers.createAnd(baseOffset++, wd, tmpDataWord, dw, String.valueOf(65280L), dw, tmpHighByte));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpLowByte, bt2, String.valueOf(8L), dw, tmpLowByteShifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpHighByte, bt2, String.valueOf(-8L), dw, tmpHighByteShifted));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpHighByteShifted, dw, tmpLowByteShifted, dw, targetRegister.getValue()));
            }
        } else if (opSize == dw) {
            if (isByteReverse) {
                String tmpByte1 = environment.getNextVariableString();
                String tmpByte2 = environment.getNextVariableString();
                String tmpByte3 = environment.getNextVariableString();
                String tmpByte4 = environment.getNextVariableString();
                String tmpByte1Shifted = environment.getNextVariableString();
                String tmpByte2Shifted = environment.getNextVariableString();
                String tmpByte3Shifted = environment.getNextVariableString();
                String tmpByte4Shifted = environment.getNextVariableString();
                String tmpTargetValue1 = environment.getNextVariableString();
                String tmpTargetValue2 = environment.getNextVariableString();
                instructions.add(ReilHelpers.createLdm(baseOffset++, dw, effectiveAddress, dw, tmpDataDWord));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpDataDWord, dw, String.valueOf(255L), dw, tmpByte1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpDataDWord, dw, String.valueOf(65280L), dw, tmpByte2));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpDataDWord, dw, String.valueOf(0xFF0000L), dw, tmpByte3));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpDataDWord, dw, String.valueOf(0xFF000000L), dw, tmpByte4));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte1, bt2, String.valueOf(24L), dw, tmpByte1Shifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte2, bt2, String.valueOf(8L), dw, tmpByte2Shifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte3, bt2, String.valueOf(-8L), dw, tmpByte3Shifted));
                instructions.add(ReilHelpers.createBsh(baseOffset++, dw, tmpByte4, bt2, String.valueOf(-24L), dw, tmpByte4Shifted));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpByte1Shifted, dw, tmpByte2Shifted, dw, tmpTargetValue1));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpByte3Shifted, dw, tmpByte4Shifted, dw, tmpTargetValue2));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, tmpTargetValue1, dw, tmpTargetValue2, dw, targetRegister.getValue()));
            } else if (loadMultiple) {
                int index = Helpers.getRegisterIndex(targetRegister.getValue());
                while (index <= 31) {
                    long l2 = baseOffset++;
                    int n2 = index++;
                    instructions.add(ReilHelpers.createLdm(l2, dw, effectiveAddress, dw, new StringBuilder(13).append("%r").append(n2).toString()));
                    instructions.add(ReilHelpers.createAdd(baseOffset++, dw, effectiveAddress, bt2, String.valueOf(4L), dw, effectiveAddress));
                }
            } else {
                instructions.add(ReilHelpers.createLdm(baseOffset++, dw, effectiveAddress, dw, targetRegister.getValue()));
            }
        }
        if (withUpdate) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, effectiveAddress, dw, sourceRegisterOperand1.getValue()));
        }
    }
}

