/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class GenericBranchGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String addressOperand, boolean setLinkRegister, boolean toCTR) throws InternalTranslationException {
        String[] stringArray;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode BOOperand = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode BIOperand = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        if (setLinkRegister) {
            String[] stringArray2 = new String[2];
            stringArray2[0] = "isCall";
            stringArray = stringArray2;
            stringArray2[1] = "true";
        } else {
            stringArray = new String[]{};
        }
        String[] meta = stringArray;
        String jumpOperand = environment.getNextVariableString();
        String ctrDecrement1 = toCTR ? null : environment.getNextVariableString();
        String ctrDecrement2 = toCTR ? null : environment.getNextVariableString();
        String ctrDecrement3 = toCTR ? null : environment.getNextVariableString();
        String tmpCountRegister = toCTR ? null : environment.getNextVariableString();
        String ctrIsZero = toCTR ? null : environment.getNextVariableString();
        String ctrIsNotZero = toCTR ? null : environment.getNextVariableString();
        String ctrCondition1 = environment.getNextVariableString();
        String ctrCondition2 = environment.getNextVariableString();
        String ctrCondition3 = environment.getNextVariableString();
        String ctrOk = toCTR ? String.valueOf(1L) : environment.getNextVariableString();
        String condCondition1 = environment.getNextVariableString();
        String condCondition2 = environment.getNextVariableString();
        String condCondition3 = environment.getNextVariableString();
        String condCondition4 = environment.getNextVariableString();
        String condCondition5 = environment.getNextVariableString();
        String condOk = environment.getNextVariableString();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        if (!toCTR) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, String.valueOf(BOOperand), bt2, String.valueOf(-2L), dw, ctrDecrement1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, ctrDecrement1, dw, String.valueOf(1L), dw, ctrDecrement2));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, ctrDecrement2, bt2, ctrDecrement3));
            instructions.add(ReilHelpers.createSub(baseOffset++, dw, "ctr", bt2, ctrDecrement3, qw, tmpCountRegister));
            instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpCountRegister, dw, String.valueOf(0xFFFFFFFFL), dw, "ctr"));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, "ctr", bt2, ctrIsZero));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, ctrIsZero, bt2, ctrIsNotZero));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, String.valueOf(BOOperand), bt2, String.valueOf(-3L), dw, ctrCondition1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, ctrCondition1, dw, String.valueOf(1L), bt2, ctrCondition2));
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, ctrIsNotZero, bt2, ctrCondition2, bt2, ctrCondition3));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, ctrDecrement2, bt2, ctrCondition3, bt2, ctrOk));
        }
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, String.valueOf(BOOperand), dw, String.valueOf(-1L), dw, condCondition1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, condCondition1, dw, String.valueOf(1L), bt2, condCondition2));
        instructions.add(ReilHelpers.createXor(baseOffset++, bt2, Helpers.getCRBit(Integer.valueOf(String.valueOf(BIOperand))), bt2, condCondition2, bt2, condCondition3));
        instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, condCondition3, bt2, condCondition4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, String.valueOf(BOOperand), dw, String.valueOf(1L), bt2, condCondition5));
        instructions.add(ReilHelpers.createOr(baseOffset++, bt2, condCondition5, bt2, condCondition4, bt2, condOk));
        instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, ctrOk, bt2, condOk, bt2, jumpOperand));
        if (setLinkRegister) {
            instructions.add(ReilHelpers.createStr(baseOffset++, dw, String.valueOf(instruction.getAddress().toLong() + 4L), dw, "lr"));
        }
        instructions.add(ReilHelpers.createJcc(baseOffset++, bt2, jumpOperand, dw, addressOperand, meta));
    }
}

