/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class DivGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, boolean isSigned, boolean setCr, boolean setOv) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand3 = instruction.getOperands().get(2).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String dividend = registerOperand2.getValue();
        String divisor = registerOperand3.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        OperandSize bt2 = OperandSize.BYTE;
        String crTemp = setCr ? environment.getNextVariableString() : null;
        String zeroCheck = environment.getNextVariableString();
        String overflowTmp1 = setOv && isSigned ? environment.getNextVariableString() : null;
        String overflowTmp2 = setOv && isSigned ? environment.getNextVariableString() : null;
        String overflowTmp3 = setOv && isSigned ? environment.getNextVariableString() : null;
        String overflowTmp4 = setOv && isSigned ? environment.getNextVariableString() : null;
        String overflowTmp5 = setOv && isSigned ? environment.getNextVariableString() : null;
        String overflowTmp6 = setOv && isSigned ? environment.getNextVariableString() : null;
        String dividendMSB = isSigned ? environment.getNextVariableString() : null;
        String divisorMSB = isSigned ? environment.getNextVariableString() : null;
        String newMSB = isSigned ? environment.getNextVariableString() : null;
        String tmpResult = isSigned ? environment.getNextVariableString() : null;
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, divisor, dw, zeroCheck));
        if (isSigned) {
            String firstComplementVar2 = environment.getNextVariableString();
            String secondComplementVar2 = environment.getNextVariableString();
            String finalComplement = environment.getNextVariableString();
            String finalFirstComplement = environment.getNextVariableString();
            String finalSecondComplement = environment.getNextVariableString();
            String firstOneComplement = environment.getNextVariableString();
            String firstTwoComplement = environment.getNextVariableString();
            String secondOneComplement = environment.getNextVariableString();
            String secondTwoComplement = environment.getNextVariableString();
            String shiftedTmpResult = environment.getNextVariableString();
            String allOnes = environment.getNextVariableString();
            String resultOneComplement = environment.getNextVariableString();
            String allOnesCheck = environment.getNextVariableString();
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, divisor, dw, String.valueOf(0xFFFFFFFFL), dw, allOnes));
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, allOnes, dw, allOnesCheck));
            instructions.add(ReilHelpers.createOr(baseOffset++, dw, zeroCheck, dw, allOnesCheck, dw, zeroCheck));
            instructions.add(ReilHelpers.createJcc(baseOffset++, dw, zeroCheck, dw, String.format("%d.%d", instruction.getAddress().toLong(), 23), new String[0]));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, dividend, bt2, String.valueOf(-31L), bt2, dividendMSB));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, divisor, bt2, String.valueOf(-31L), bt2, divisorMSB));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, dividendMSB, bt2, firstComplementVar2));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, divisorMSB, bt2, secondComplementVar2));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, String.valueOf(0xFFFFFFFFL), bt2, firstComplementVar2, dw, finalFirstComplement));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, finalFirstComplement, dw, String.valueOf(0xFFFFFFFFL), dw, finalFirstComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, String.valueOf(0xFFFFFFFFL), bt2, secondComplementVar2, dw, finalSecondComplement));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, finalSecondComplement, dw, String.valueOf(0xFFFFFFFFL), dw, finalSecondComplement));
            instructions.add(ReilHelpers.createXor(baseOffset++, bt2, dividendMSB, bt2, divisorMSB, bt2, newMSB));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, finalFirstComplement, dw, finalSecondComplement, dw, finalComplement));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, dividend, dw, finalFirstComplement, dw, firstOneComplement));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, divisor, dw, finalSecondComplement, dw, secondOneComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, firstOneComplement, bt2, dividendMSB, dw, firstTwoComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, secondOneComplement, bt2, divisorMSB, dw, secondTwoComplement));
            instructions.add(ReilHelpers.createDiv(baseOffset++, dw, firstTwoComplement, dw, secondTwoComplement, dw, tmpResult));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpResult, dw, String.valueOf(0xFFFFFFFFL), dw, shiftedTmpResult));
            instructions.add(ReilHelpers.createXor(baseOffset++, dw, shiftedTmpResult, dw, finalComplement, dw, resultOneComplement));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, resultOneComplement, bt2, newMSB, dw, tmpResult));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpResult, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        } else {
            instructions.add(ReilHelpers.createJcc(baseOffset++, dw, zeroCheck, dw, String.format("%d.%d", instruction.getAddress().toLong(), 3), new String[0]));
            instructions.add(ReilHelpers.createDiv(baseOffset++, dw, dividend, dw, divisor, dw, targetRegister));
        }
        if (setOv) {
            if (isSigned) {
                instructions.add(ReilHelpers.createBisz(baseOffset++, dw, divisor, dw, overflowTmp1));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, divisor, dw, String.valueOf(0xFFFFFFFFL), dw, overflowTmp2));
                instructions.add(ReilHelpers.createBisz(baseOffset++, dw, overflowTmp2, dw, overflowTmp3));
                instructions.add(ReilHelpers.createXor(baseOffset++, dw, dividend, dw, String.valueOf(0x80000000L), dw, overflowTmp4));
                instructions.add(ReilHelpers.createBisz(baseOffset++, dw, overflowTmp4, dw, overflowTmp5));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, overflowTmp3, dw, overflowTmp5, dw, overflowTmp6));
                instructions.add(ReilHelpers.createOr(baseOffset++, dw, overflowTmp1, dw, overflowTmp6, bt2, "XEROV"));
                instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "XEROV", bt2, "XERSO", bt2, "XERSO"));
            } else {
                instructions.add(ReilHelpers.createBisz(baseOffset++, dw, divisor, bt2, "XEROV"));
                instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "XEROV", bt2, "XERSO", bt2, "XERSO"));
            }
        }
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, wd, "-31", bt2, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, bt2, "CR0EQ", bt2, "CR0LT", bt2, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, crTemp, bt2, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, bt2, "XERSO", bt2, "CR0SO"));
        }
    }
}

