/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.ppc.BranchGenerator;
import com.google.security.zynamics.reil.translators.ppc.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class BlectrTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "blectr");
        Long baseOffset = instruction.getAddress().toLong() * 256L;
        String jumpOperand = environment.getNextVariableString();
        IOperandTreeNode BIOperand = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        Long l2 = baseOffset;
        Long l3 = baseOffset = Long.valueOf(baseOffset + 1L);
        instructions.add(ReilHelpers.createOr(l2, OperandSize.BYTE, String.valueOf(Helpers.getCRRegisterIndex(BIOperand.getValue()) * 4 + 2), OperandSize.BYTE, String.valueOf(Helpers.getCRRegisterIndex(BIOperand.getValue()) * 4 + 0), OperandSize.BYTE, jumpOperand));
        BranchGenerator.generate(baseOffset, environment, instruction, instructions, "blectr", jumpOperand, "ctr", false, false, false, false, false, false);
    }
}

