/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.ppc;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class AddGenerator {
    public static void generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, String mnemonic, String firstOperand, String secondOperand, boolean setCr, boolean setOverflow, boolean setCarry, boolean isExtended) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, mnemonic);
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String extendedAddResult = environment.getNextVariableString();
        String afterCarryAddition = isExtended ? environment.getNextVariableString() : null;
        String tmpVar3 = setOverflow ? environment.getNextVariableString() : null;
        String tmpVar4 = setOverflow ? environment.getNextVariableString() : null;
        String overflowTmp = setOverflow ? environment.getNextVariableString() : null;
        String msbVara = setOverflow ? environment.getNextVariableString() : null;
        String msbVarb = setOverflow ? environment.getNextVariableString() : null;
        String msbVarr = setOverflow ? environment.getNextVariableString() : null;
        String crTemp = setCr ? environment.getNextVariableString() : null;
        instructions.add(ReilHelpers.createAdd(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.DWORD, secondOperand, OperandSize.QWORD, extendedAddResult));
        if (isExtended) {
            instructions.add(ReilHelpers.createAdd(baseOffset++, OperandSize.QWORD, extendedAddResult, OperandSize.BYTE, "XERCA", OperandSize.QWORD, afterCarryAddition));
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, afterCarryAddition, OperandSize.DWORD, "4294967295", OperandSize.DWORD, targetRegister));
        } else {
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, extendedAddResult, OperandSize.DWORD, "4294967295", OperandSize.DWORD, targetRegister));
        }
        if (setOverflow) {
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, firstOperand, OperandSize.WORD, "-31", OperandSize.DWORD, msbVara));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, secondOperand, OperandSize.WORD, "-31", OperandSize.DWORD, msbVarb));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.DWORD, msbVarr));
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, msbVara, OperandSize.DWORD, msbVarr, OperandSize.DWORD, tmpVar4));
            instructions.add(ReilHelpers.createXor(baseOffset++, OperandSize.DWORD, msbVarb, OperandSize.DWORD, msbVarr, OperandSize.DWORD, tmpVar3));
            instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.DWORD, tmpVar4, OperandSize.DWORD, tmpVar3, OperandSize.DWORD, overflowTmp));
            instructions.add(ReilHelpers.createStr(baseOffset++, OperandSize.DWORD, overflowTmp, OperandSize.WORD, "XEROV"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.WORD, "XERSO", OperandSize.DWORD, overflowTmp, OperandSize.WORD, "XERSO"));
        }
        if (setCarry) {
            if (isExtended) {
                instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.QWORD, afterCarryAddition, OperandSize.DWORD, "-32", OperandSize.WORD, "XERCA"));
            } else {
                instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.QWORD, extendedAddResult, OperandSize.DWORD, "-32", OperandSize.WORD, "XERCA"));
            }
        }
        if (setCr) {
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.BYTE, "CR0EQ"));
            instructions.add(ReilHelpers.createBsh(baseOffset++, OperandSize.DWORD, targetRegister, OperandSize.WORD, "-31", OperandSize.BYTE, "CR0LT"));
            instructions.add(ReilHelpers.createOr(baseOffset++, OperandSize.BYTE, "CR0EQ", OperandSize.BYTE, "CR0LT", OperandSize.BYTE, crTemp));
            instructions.add(ReilHelpers.createBisz(baseOffset++, OperandSize.BYTE, crTemp, OperandSize.BYTE, "CR0GT"));
            instructions.add(ReilHelpers.createStr(baseOffset, OperandSize.BYTE, "XERSO", OperandSize.BYTE, "CR0SO"));
        }
    }
}

