/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.ITranslationExtension;
import com.google.security.zynamics.reil.translators.ITranslator;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.mips.AddTranslator;
import com.google.security.zynamics.reil.translators.mips.AddiTranslator;
import com.google.security.zynamics.reil.translators.mips.AddiuTranslator;
import com.google.security.zynamics.reil.translators.mips.AdduTranslator;
import com.google.security.zynamics.reil.translators.mips.AndTranslator;
import com.google.security.zynamics.reil.translators.mips.AndiTranslator;
import com.google.security.zynamics.reil.translators.mips.BTranslator;
import com.google.security.zynamics.reil.translators.mips.BalTranslator;
import com.google.security.zynamics.reil.translators.mips.BeqTranslator;
import com.google.security.zynamics.reil.translators.mips.BeqlTranslator;
import com.google.security.zynamics.reil.translators.mips.BeqzTranslator;
import com.google.security.zynamics.reil.translators.mips.BeqzlTranslator;
import com.google.security.zynamics.reil.translators.mips.BgezTranslator;
import com.google.security.zynamics.reil.translators.mips.BgezalTranslator;
import com.google.security.zynamics.reil.translators.mips.BgezallTranslator;
import com.google.security.zynamics.reil.translators.mips.BgezlTranslator;
import com.google.security.zynamics.reil.translators.mips.BgtzTranslator;
import com.google.security.zynamics.reil.translators.mips.BgtzlTranslator;
import com.google.security.zynamics.reil.translators.mips.BlezTranslator;
import com.google.security.zynamics.reil.translators.mips.BlezlTranslator;
import com.google.security.zynamics.reil.translators.mips.BltzTranslator;
import com.google.security.zynamics.reil.translators.mips.BltzalTranslator;
import com.google.security.zynamics.reil.translators.mips.BltzallTranslator;
import com.google.security.zynamics.reil.translators.mips.BltzlTranslator;
import com.google.security.zynamics.reil.translators.mips.BneTranslator;
import com.google.security.zynamics.reil.translators.mips.BnelTranslator;
import com.google.security.zynamics.reil.translators.mips.BnezTranslator;
import com.google.security.zynamics.reil.translators.mips.BreakTranslator;
import com.google.security.zynamics.reil.translators.mips.CloTranslator;
import com.google.security.zynamics.reil.translators.mips.ClzTranslator;
import com.google.security.zynamics.reil.translators.mips.DivTranslator;
import com.google.security.zynamics.reil.translators.mips.DivuTranslator;
import com.google.security.zynamics.reil.translators.mips.EhbTranslator;
import com.google.security.zynamics.reil.translators.mips.ExtTranslator;
import com.google.security.zynamics.reil.translators.mips.InsTranslator;
import com.google.security.zynamics.reil.translators.mips.JTranslator;
import com.google.security.zynamics.reil.translators.mips.JalTranslator;
import com.google.security.zynamics.reil.translators.mips.JalrDotHbTranslator;
import com.google.security.zynamics.reil.translators.mips.JalrTranslator;
import com.google.security.zynamics.reil.translators.mips.JrDotHbTranslator;
import com.google.security.zynamics.reil.translators.mips.JrTranslator;
import com.google.security.zynamics.reil.translators.mips.LaTranslator;
import com.google.security.zynamics.reil.translators.mips.LbTranslator;
import com.google.security.zynamics.reil.translators.mips.LbuTranslator;
import com.google.security.zynamics.reil.translators.mips.LhTranslator;
import com.google.security.zynamics.reil.translators.mips.LhuTranslator;
import com.google.security.zynamics.reil.translators.mips.LiTranslator;
import com.google.security.zynamics.reil.translators.mips.LlTranslator;
import com.google.security.zynamics.reil.translators.mips.LuiTranslator;
import com.google.security.zynamics.reil.translators.mips.LwTranslator;
import com.google.security.zynamics.reil.translators.mips.LwlTranslator;
import com.google.security.zynamics.reil.translators.mips.LwrTranslator;
import com.google.security.zynamics.reil.translators.mips.MaddTranslator;
import com.google.security.zynamics.reil.translators.mips.MadduTranslator;
import com.google.security.zynamics.reil.translators.mips.MfhiTranslator;
import com.google.security.zynamics.reil.translators.mips.MfloTranslator;
import com.google.security.zynamics.reil.translators.mips.MoveTranslator;
import com.google.security.zynamics.reil.translators.mips.MovfTranslator;
import com.google.security.zynamics.reil.translators.mips.MovnTranslator;
import com.google.security.zynamics.reil.translators.mips.MovtTranslator;
import com.google.security.zynamics.reil.translators.mips.MovzTranslator;
import com.google.security.zynamics.reil.translators.mips.MsubTranslator;
import com.google.security.zynamics.reil.translators.mips.MsubuTranslator;
import com.google.security.zynamics.reil.translators.mips.MthiTranslator;
import com.google.security.zynamics.reil.translators.mips.MtloTranslator;
import com.google.security.zynamics.reil.translators.mips.MulTranslator;
import com.google.security.zynamics.reil.translators.mips.MultTranslator;
import com.google.security.zynamics.reil.translators.mips.MultuTranslator;
import com.google.security.zynamics.reil.translators.mips.NeguTranslator;
import com.google.security.zynamics.reil.translators.mips.NopTranslator;
import com.google.security.zynamics.reil.translators.mips.NorTranslator;
import com.google.security.zynamics.reil.translators.mips.OrTranslator;
import com.google.security.zynamics.reil.translators.mips.OriTranslator;
import com.google.security.zynamics.reil.translators.mips.PauseTranslator;
import com.google.security.zynamics.reil.translators.mips.PrefTranslator;
import com.google.security.zynamics.reil.translators.mips.RdhwrTranslator;
import com.google.security.zynamics.reil.translators.mips.RotrTranslator;
import com.google.security.zynamics.reil.translators.mips.RotrvTranslator;
import com.google.security.zynamics.reil.translators.mips.SbTranslator;
import com.google.security.zynamics.reil.translators.mips.ScTranslator;
import com.google.security.zynamics.reil.translators.mips.SebTranslator;
import com.google.security.zynamics.reil.translators.mips.SehTranslator;
import com.google.security.zynamics.reil.translators.mips.ShTranslator;
import com.google.security.zynamics.reil.translators.mips.SllTranslator;
import com.google.security.zynamics.reil.translators.mips.SllvTranslator;
import com.google.security.zynamics.reil.translators.mips.SltTranslator;
import com.google.security.zynamics.reil.translators.mips.SltiTranslator;
import com.google.security.zynamics.reil.translators.mips.SltiuTranslator;
import com.google.security.zynamics.reil.translators.mips.SltuTranslator;
import com.google.security.zynamics.reil.translators.mips.SraTranslator;
import com.google.security.zynamics.reil.translators.mips.SravTranslator;
import com.google.security.zynamics.reil.translators.mips.SrlTranslator;
import com.google.security.zynamics.reil.translators.mips.SrlvTranslator;
import com.google.security.zynamics.reil.translators.mips.SsnopTranslator;
import com.google.security.zynamics.reil.translators.mips.SubTranslator;
import com.google.security.zynamics.reil.translators.mips.SubuTranslator;
import com.google.security.zynamics.reil.translators.mips.SwTranslator;
import com.google.security.zynamics.reil.translators.mips.SwlTranslator;
import com.google.security.zynamics.reil.translators.mips.SwrTranslator;
import com.google.security.zynamics.reil.translators.mips.SyncTranslator;
import com.google.security.zynamics.reil.translators.mips.SynciTranslator;
import com.google.security.zynamics.reil.translators.mips.SyscallTranslator;
import com.google.security.zynamics.reil.translators.mips.TeqTranslator;
import com.google.security.zynamics.reil.translators.mips.TeqiTranslator;
import com.google.security.zynamics.reil.translators.mips.TgeTranslator;
import com.google.security.zynamics.reil.translators.mips.TgeiTranslator;
import com.google.security.zynamics.reil.translators.mips.TgeiuTranslator;
import com.google.security.zynamics.reil.translators.mips.TgeuTranslator;
import com.google.security.zynamics.reil.translators.mips.TltTranslator;
import com.google.security.zynamics.reil.translators.mips.TltiTranslator;
import com.google.security.zynamics.reil.translators.mips.TltiuTranslator;
import com.google.security.zynamics.reil.translators.mips.TltuTranslator;
import com.google.security.zynamics.reil.translators.mips.TneTranslator;
import com.google.security.zynamics.reil.translators.mips.TneiTranslator;
import com.google.security.zynamics.reil.translators.mips.WsbhTranslator;
import com.google.security.zynamics.reil.translators.mips.XorTranslator;
import com.google.security.zynamics.reil.translators.mips.XoriTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class TranslatorMIPS<InstructionType extends IInstruction>
implements ITranslator<InstructionType> {
    private static HashMap<String, IInstructionTranslator> translators = new HashMap();

    @Override
    public List<ReilInstruction> translate(ITranslationEnvironment environment, InstructionType instruction, List<ITranslationExtension<InstructionType>> extensions) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        String mnemonic = instruction.getMnemonic();
        if (mnemonic == null) {
            return new ArrayList<ReilInstruction>();
        }
        IInstructionTranslator translator = translators.get(mnemonic.toLowerCase());
        if (translators.containsKey(mnemonic.toLowerCase())) {
            ArrayList<ReilInstruction> instructions = new ArrayList<ReilInstruction>();
            translator.translate(environment, (IInstruction)instruction, (List<ReilInstruction>)instructions);
            for (ITranslationExtension<InstructionType> extension2 : extensions) {
                extension2.postProcess(environment, instruction, instructions);
            }
            return instructions;
        }
        return Lists.newArrayList(ReilHelpers.createUnknown(ReilHelpers.toReilAddress(instruction.getAddress()).toLong()));
    }

    static {
        try {
            translators.put("add", new AddTranslator());
            translators.put("addi", new AddiTranslator());
            translators.put("addiu", new AddiuTranslator());
            translators.put("addu", new AdduTranslator());
            translators.put("clo", new CloTranslator());
            translators.put("clz", new ClzTranslator());
            translators.put("div", new DivTranslator());
            translators.put("divu", new DivuTranslator());
            translators.put("madd", new MaddTranslator());
            translators.put("maddu", new MadduTranslator());
            translators.put("msub", new MsubTranslator());
            translators.put("msubu", new MsubuTranslator());
            translators.put("mul", new MulTranslator());
            translators.put("mult", new MultTranslator());
            translators.put("multu", new MultuTranslator());
            translators.put("negu", new NeguTranslator());
            translators.put("seb", new SebTranslator());
            translators.put("seh", new SehTranslator());
            translators.put("slt", new SltTranslator());
            translators.put("slti", new SltiTranslator());
            translators.put("sltiu", new SltiuTranslator());
            translators.put("sltu", new SltuTranslator());
            translators.put("sub", new SubTranslator());
            translators.put("subu", new SubuTranslator());
            translators.put("b", new BTranslator());
            translators.put("bal", new BalTranslator());
            translators.put("beq", new BeqTranslator());
            translators.put("bgez", new BgezTranslator());
            translators.put("bgezal", new BgezalTranslator());
            translators.put("bgtz", new BgtzTranslator());
            translators.put("blez", new BlezTranslator());
            translators.put("bltz", new BltzTranslator());
            translators.put("bltzal", new BltzalTranslator());
            translators.put("bne", new BneTranslator());
            translators.put("j", new JTranslator());
            translators.put("jal", new JalTranslator());
            translators.put("jalr", new JalrTranslator());
            translators.put("jalr.hb", new JalrDotHbTranslator());
            translators.put("jr", new JrTranslator());
            translators.put("jr.hb", new JrDotHbTranslator());
            translators.put("ehb", new EhbTranslator());
            translators.put("nop", new NopTranslator());
            translators.put("pause", new PauseTranslator());
            translators.put("ssnop", new SsnopTranslator());
            translators.put("lb", new LbTranslator());
            translators.put("lbu", new LbuTranslator());
            translators.put("lh", new LhTranslator());
            translators.put("lhu", new LhuTranslator());
            translators.put("ll", new LlTranslator());
            translators.put("lw", new LwTranslator());
            translators.put("lwl", new LwlTranslator());
            translators.put("lwr", new LwrTranslator());
            translators.put("pref", new PrefTranslator());
            translators.put("sb", new SbTranslator());
            translators.put("sc", new ScTranslator());
            translators.put("sh", new ShTranslator());
            translators.put("sw", new SwTranslator());
            translators.put("swl", new SwlTranslator());
            translators.put("swr", new SwrTranslator());
            translators.put("sync", new SyncTranslator());
            translators.put("synci", new SynciTranslator());
            translators.put("and", new AndTranslator());
            translators.put("andi", new AndiTranslator());
            translators.put("lui", new LuiTranslator());
            translators.put("nor", new NorTranslator());
            translators.put("or", new OrTranslator());
            translators.put("ori", new OriTranslator());
            translators.put("xor", new XorTranslator());
            translators.put("xori", new XoriTranslator());
            translators.put("ext", new ExtTranslator());
            translators.put("ins", new InsTranslator());
            translators.put("wsbh", new WsbhTranslator());
            translators.put("mfhi", new MfhiTranslator());
            translators.put("mflo", new MfloTranslator());
            translators.put("movf", new MovfTranslator());
            translators.put("movn", new MovnTranslator());
            translators.put("movt", new MovtTranslator());
            translators.put("movz", new MovzTranslator());
            translators.put("mthi", new MthiTranslator());
            translators.put("mtlo", new MtloTranslator());
            translators.put("rdhwr", new RdhwrTranslator());
            translators.put("rotr", new RotrTranslator());
            translators.put("rotrv", new RotrvTranslator());
            translators.put("sll", new SllTranslator());
            translators.put("sllv", new SllvTranslator());
            translators.put("sra", new SraTranslator());
            translators.put("srav", new SravTranslator());
            translators.put("srl", new SrlTranslator());
            translators.put("srlv", new SrlvTranslator());
            translators.put("break", new BreakTranslator());
            translators.put("syscall", new SyscallTranslator());
            translators.put("teq", new TeqTranslator());
            translators.put("teqi", new TeqiTranslator());
            translators.put("tge", new TgeTranslator());
            translators.put("tgei", new TgeiTranslator());
            translators.put("tgeiu", new TgeiuTranslator());
            translators.put("tgeu", new TgeuTranslator());
            translators.put("tlt", new TltTranslator());
            translators.put("tlti", new TltiTranslator());
            translators.put("tltiu", new TltiuTranslator());
            translators.put("tltu", new TltuTranslator());
            translators.put("tne", new TneTranslator());
            translators.put("tnei", new TneiTranslator());
            translators.put("beql", new BeqlTranslator());
            translators.put("bgezall", new BgezallTranslator());
            translators.put("bgezl", new BgezlTranslator());
            translators.put("bgtzl", new BgtzlTranslator());
            translators.put("blezl", new BlezlTranslator());
            translators.put("bltzall", new BltzallTranslator());
            translators.put("bltzl", new BltzlTranslator());
            translators.put("bnel", new BnelTranslator());
            translators.put("la", new LaTranslator());
            translators.put("li", new LiTranslator());
            translators.put("move", new MoveTranslator());
            translators.put("beqz", new BeqzTranslator());
            translators.put("beqzl", new BeqzlTranslator());
            translators.put("bnez", new BnezTranslator());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

