/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.mips.OperandLoader;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class SignExtendGenerator {
    public static String extend16BitTo32(long baseOffset, ITranslationEnvironment environment, String sourceValue, List<ReilInstruction> instructions) {
        String targetRegister = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceValue, dw, String.valueOf(32768), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(65535L), dw, tmpVar2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, String.valueOf(32768L), dw, targetRegister));
        return targetRegister;
    }

    public static String extend16BitTo64(long baseOffset, ITranslationEnvironment environment, String sourceValue, List<ReilInstruction> instructions) {
        String targetRegister = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        OperandSize qw = OperandSize.QWORD;
        instructions.add(ReilHelpers.createAdd(baseOffset++, qw, sourceValue, qw, String.valueOf(32768L), qw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, qw, String.valueOf(65535L), qw, tmpVar2));
        instructions.add(ReilHelpers.createSub(baseOffset++, qw, tmpVar2, qw, String.valueOf(32768L), qw, targetRegister));
        return targetRegister;
    }

    public static String extend8BitTo32(long baseOffset, ITranslationEnvironment environment, String sourceValue, List<ReilInstruction> instructions) {
        String targetRegister = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceValue, dw, String.valueOf(128), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(255L), dw, tmpVar2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, String.valueOf(128L), dw, targetRegister));
        return targetRegister;
    }

    public static String extendAndAdd(long baseOffset, ITranslationEnvironment environment, IOperandTree operand, List<ReilInstruction> instructions) throws InternalTranslationException {
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String targetRegister = environment.getNextVariableString();
        String addedValue = environment.getNextVariableString();
        String truncatedValue = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        Pair<IOperandTreeNode, IOperandTreeNode> combinedOperand = OperandLoader.load(operand.getRootNode());
        if (combinedOperand.second() == null) {
            return combinedOperand.first().getValue();
        }
        String register2 = combinedOperand.first().getValue();
        String integerValue = combinedOperand.second().getValue();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, integerValue, dw, String.valueOf(32768), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(65535L), dw, tmpVar2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, String.valueOf(32768L), dw, targetRegister));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, register2, dw, targetRegister, OperandSize.QWORD, addedValue));
        instructions.add(ReilHelpers.createAnd(baseOffset++, OperandSize.QWORD, addedValue, dw, String.valueOf(0xFFFFFFFFL), dw, truncatedValue));
        return truncatedValue;
    }

    public static String extendFromByte(long baseOffset, ITranslationEnvironment environment, String sourceValue, List<ReilInstruction> instructions) {
        String targetRegister = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        instructions.add(ReilHelpers.createAdd(baseOffset++, OperandSize.BYTE, sourceValue, OperandSize.BYTE, String.valueOf(128), dw, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpVar1, dw, String.valueOf(255L), dw, tmpVar2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dw, tmpVar2, dw, String.valueOf(128L), dw, targetRegister));
        return targetRegister;
    }
}

