/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.OperandLoader;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Triple;
import java.util.List;

public class RotrvTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "rotrv");
        Triple<IOperandTree, IOperandTree, IOperandTree> operands = OperandLoader.loadDuplicateFirst(instruction);
        String rd = operands.first().getRootNode().getChildren().get(0).getValue();
        String rt = operands.second().getRootNode().getChildren().get(0).getValue();
        String rs = operands.third().getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        String lowShiftRegisterBits = environment.getNextVariableString();
        String lowRotateBits = environment.getNextVariableString();
        String highRotateBits = environment.getNextVariableString();
        String temporaryRotateResult = environment.getNextVariableString();
        String negativeRt = environment.getNextVariableString();
        String negativeShiftValue = environment.getNextVariableString();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        instructions.add(ReilHelpers.createAnd(offset++, dw, rs, dw, String.valueOf(31L), dw, lowShiftRegisterBits));
        instructions.add(ReilHelpers.createSub(offset++, dw, String.valueOf(0L), dw, rs, dw, negativeRt));
        instructions.add(ReilHelpers.createSub(offset++, dw, String.valueOf(32L), dw, rs, dw, negativeShiftValue));
        instructions.add(ReilHelpers.createBsh(offset++, dw, rt, dw, negativeRt, dw, lowRotateBits));
        instructions.add(ReilHelpers.createBsh(offset++, dw, rt, dw, negativeShiftValue, dw, highRotateBits));
        instructions.add(ReilHelpers.createOr(offset++, dw, lowRotateBits, dw, highRotateBits, dw, temporaryRotateResult));
        instructions.add(ReilHelpers.createAnd(offset++, dw, temporaryRotateResult, dw, String.valueOf(0xFFFFFFFFL), dw, rd));
    }
}

