/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.OperandLoader;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.general.Triple;
import java.util.List;

public class RotrTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "rotr");
        Triple<IOperandTree, IOperandTree, IOperandTree> operands = OperandLoader.loadDuplicateFirst(instruction);
        String rd = operands.first().getRootNode().getChildren().get(0).getValue();
        String rt = operands.second().getRootNode().getChildren().get(0).getValue();
        String sa = operands.third().getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        String lowRotateBits = environment.getNextVariableString();
        String highRotateBits = environment.getNextVariableString();
        String temporaryRotateResult = environment.getNextVariableString();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        long l2 = offset++;
        String string2 = String.valueOf(Integer.decode(sa));
        instructions.add(ReilHelpers.createBsh(l2, dw, rt, dw, new StringBuilder(1 + String.valueOf(string2).length()).append("-").append(string2).toString(), dw, lowRotateBits));
        instructions.add(ReilHelpers.createBsh(offset++, dw, rt, dw, String.valueOf(32 - Integer.decode(sa)), dw, highRotateBits));
        instructions.add(ReilHelpers.createOr(offset++, dw, lowRotateBits, dw, highRotateBits, dw, temporaryRotateResult));
        instructions.add(ReilHelpers.createAnd(offset++, dw, temporaryRotateResult, dw, String.valueOf(0xFFFFFFFFL), dw, rd));
    }
}

