/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import com.google.security.zynamics.zylib.general.Triple;
import java.util.List;

public class OperandLoader {
    public static Pair<IOperandTreeNode, IOperandTreeNode> load(IOperandTreeNode root) throws InternalTranslationException {
        IOperandTreeNode base2 = root.getChildren().get(0);
        if (base2.getType() == ExpressionType.MEMDEREF) {
            return new Pair<IOperandTreeNode, Object>(base2.getChildren().get(0), null);
        }
        if (base2.getType() != ExpressionType.OPERATOR) {
            throw new InternalTranslationException("Malformed operand");
        }
        if (base2.getChildren().size() != 2) {
            throw new InternalTranslationException("Malformed operand");
        }
        return new Pair<IOperandTreeNode, IOperandTreeNode>(base2.getChildren().get(0), base2.getChildren().get(1));
    }

    public static Triple<IOperandTree, IOperandTree, IOperandTree> loadDuplicateFirst(IInstruction instruction) {
        List<? extends IOperandTree> operands = instruction.getOperands();
        IOperandTree operand1 = operands.get(0);
        IOperandTree operand2 = operands.size() == 2 ? operands.get(0) : operands.get(1);
        IOperandTree operand3 = operands.size() == 2 ? operands.get(1) : operands.get(2);
        return new Triple<IOperandTree, IOperandTree, IOperandTree>(operand1, operand2, operand3);
    }
}

