/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class MultTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "mult");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String tempResult = environment.getNextVariableString();
        String temporaryHiResult = environment.getNextVariableString();
        Helpers.signedMul(offset, environment, instructions, dw, sourceRegister1, dw, sourceRegister2, qw, tempResult);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createAnd(offset++, qw, tempResult, dw, String.valueOf(0xFFFFFFFFL), dw, "LO"));
        instructions.add(ReilHelpers.createBsh(offset, qw, tempResult, dw, String.valueOf(-32L), dw, temporaryHiResult));
        instructions.add(ReilHelpers.createAnd(offset, dw, temporaryHiResult, dw, String.valueOf(0xFFFFFFFFL), dw, "HI"));
    }
}

