/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class MsubTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "msub");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        OperandSize bt2 = OperandSize.BYTE;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String signedMultiplicationResult = environment.getNextVariableString();
        String hiShifted = environment.getNextVariableString();
        String hiAndLoConcatenated = environment.getNextVariableString();
        String temporaryResult = environment.getNextVariableString();
        String temp = environment.getNextVariableString();
        String temporaryHigh = environment.getNextVariableString();
        Helpers.signedMul(offset, environment, instructions, dw, sourceRegister1, dw, sourceRegister2, qw, signedMultiplicationResult);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createBsh(offset++, dw, "HI", dw, String.valueOf(32L), qw, hiShifted));
        instructions.add(ReilHelpers.createOr(offset++, qw, hiShifted, dw, "LO", qw, hiAndLoConcatenated));
        Helpers.signedSub(offset, environment, instructions, hiAndLoConcatenated, signedMultiplicationResult, temporaryResult, temp);
        offset = baseOffset + (long)instructions.size();
        String resultOperand = environment.getNextVariableString();
        String toggleMask = environment.getNextVariableString();
        String xoredResult = environment.getNextVariableString();
        String xoredSigns = environment.getNextVariableString();
        String signOne = environment.getNextVariableString();
        String signTwo = environment.getNextVariableString();
        String realSignTwo = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(offset++, dw, "HI", dw, String.valueOf(-31L), bt2, signOne));
        instructions.add(ReilHelpers.createBsh(offset++, qw, signedMultiplicationResult, dw, String.valueOf(-63L), bt2, signTwo));
        instructions.add(ReilHelpers.createAnd(offset++, bt2, signTwo, bt2, String.valueOf(1L), bt2, realSignTwo));
        instructions.add(ReilHelpers.createXor(offset++, bt2, signOne, bt2, realSignTwo, dw, xoredSigns));
        instructions.add(ReilHelpers.createSub(offset++, dw, "0", dw, xoredSigns, dw, toggleMask));
        instructions.add(ReilHelpers.createXor(offset++, qw, toggleMask, qw, temporaryResult, qw, xoredResult));
        instructions.add(ReilHelpers.createAdd(offset++, qw, xoredResult, dw, xoredSigns, qw, resultOperand));
        instructions.add(ReilHelpers.createAnd(offset++, qw, resultOperand, dw, String.valueOf(0xFFFFFFFFL), dw, "LO"));
        instructions.add(ReilHelpers.createBsh(offset++, qw, resultOperand, dw, String.valueOf(-32L), dw, temporaryHigh));
        instructions.add(ReilHelpers.createAnd(offset++, qw, temporaryHigh, dw, String.valueOf(0xFFFFFFFFL), dw, "HI"));
    }
}

