/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class LwrTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "lwr");
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        String lastTwoAddressBits = environment.getNextVariableString();
        String shiftValue = environment.getNextVariableString();
        String memoryShiftAmount = environment.getNextVariableString();
        String registerMaskShiftAmount = environment.getNextVariableString();
        String shiftedMemoryContent = environment.getNextVariableString();
        String shiftedMemoryMask = environment.getNextVariableString();
        String maskedRegisterContent = environment.getNextVariableString();
        String temporaryResult = environment.getNextVariableString();
        String memoryContent = environment.getNextVariableString();
        String address = environment.getNextVariableString();
        IOperandTreeNode targetRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String extendedValue = SignExtendGenerator.extendAndAdd(offset, environment, instruction.getOperands().get(1), instructions);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createAnd(offset++, dw, extendedValue, dw, String.valueOf(0xFFFFFFFCL), dw, address));
        instructions.add(ReilHelpers.createLdm(offset, dw, address, dw, memoryContent));
        instructions.add(ReilHelpers.createAnd(offset++, dw, extendedValue, dw, String.valueOf(3L), dw, lastTwoAddressBits));
        instructions.add(ReilHelpers.createBsh(offset++, dw, lastTwoAddressBits, dw, String.valueOf(3L), dw, shiftValue));
        String endianess = "little";
        if ("little".equalsIgnoreCase("little")) {
            instructions.add(ReilHelpers.createSub(offset++, dw, String.valueOf(0L), dw, shiftValue, dw, memoryShiftAmount));
            instructions.add(ReilHelpers.createSub(offset++, dw, String.valueOf(32L), dw, shiftValue, dw, registerMaskShiftAmount));
        } else if ("little".equalsIgnoreCase("big")) {
            instructions.add(ReilHelpers.createAdd(offset++, dw, String.valueOf(-24L), dw, shiftValue, dw, memoryShiftAmount));
            instructions.add(ReilHelpers.createAdd(offset++, dw, String.valueOf(8L), dw, shiftValue, dw, registerMaskShiftAmount));
        }
        instructions.add(ReilHelpers.createBsh(offset++, dw, memoryContent, dw, memoryShiftAmount, qw, shiftedMemoryContent));
        instructions.add(ReilHelpers.createBsh(offset++, dw, String.valueOf(0xFFFFFFFFL), dw, registerMaskShiftAmount, dw, shiftedMemoryMask));
        instructions.add(ReilHelpers.createAnd(offset++, dw, targetRegister.getValue(), dw, shiftedMemoryMask, dw, maskedRegisterContent));
        instructions.add(ReilHelpers.createOr(offset++, dw, maskedRegisterContent, qw, shiftedMemoryContent, qw, temporaryResult));
        instructions.add(ReilHelpers.createAnd(offset++, qw, temporaryResult, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister.getValue()));
    }
}

