/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class LhuTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "lhu");
        String rt = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        OperandSize dw = OperandSize.DWORD;
        OperandSize wd = OperandSize.WORD;
        String result = SignExtendGenerator.extendAndAdd(offset, environment, instruction.getOperands().get(1), instructions);
        offset = baseOffset + (long)instructions.size();
        instructions.add(ReilHelpers.createLdm(offset++, dw, result, wd, rt));
    }
}

