/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class Helpers {
    private static int registerSize = 32;

    private static void generateDelayBranchInternal(List<ReilInstruction> instructions, long baseOffset, OperandSize conditionSize, String conditionOperand, OperandSize targetSize, IOperandTreeNode targetOperand, String[] meta) {
        long offset = baseOffset;
        if (targetOperand.getType() != ExpressionType.REGISTER) {
            instructions.add(ReilHelpers.createStr(offset++, conditionSize, conditionOperand, conditionSize, "t254"));
            instructions.add(ReilHelpers.createJcc(offset, conditionSize, "t254", targetSize, targetOperand.getValue(), meta));
        } else {
            instructions.add(ReilHelpers.createStr(offset++, targetSize, targetOperand.getValue(), targetSize, "t255"));
            instructions.add(ReilHelpers.createStr(offset++, conditionSize, conditionOperand, conditionSize, "t254"));
            instructions.add(ReilHelpers.createJcc(offset, conditionSize, "t254", targetSize, "t255", meta));
        }
    }

    private static Pair<String, String> generateSignMask(ITranslationEnvironment environment, long offset, String value, OperandSize size, List<ReilInstruction> instructions) {
        String msbMask = String.valueOf(TranslationHelpers.getMsbMask(size));
        String shiftValue = String.valueOf(TranslationHelpers.getShiftMsbLsbMask(size));
        String maskedMsb = environment.getNextVariableString();
        String msbInLsb = environment.getNextVariableString();
        String signMask = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(offset, size, value, size, msbMask, size, maskedMsb));
        instructions.add(ReilHelpers.createBsh(offset + 1L, size, maskedMsb, size, shiftValue, size, msbInLsb));
        instructions.add(ReilHelpers.createSub(offset + 2L, size, "0", size, msbInLsb, size, signMask));
        return new Pair<String, String>(msbInLsb, signMask);
    }

    public static Pair<String, String> generateAbs(ITranslationEnvironment environment, long baseOffset, String value, OperandSize size, List<ReilInstruction> instructions) throws IllegalArgumentException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(value, "Error: Argument value can't be null");
        Preconditions.checkNotNull(size, "Error: Argument size can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        int oldInstructionsSize = instructions.size();
        Pair<String, String> signMask = Helpers.generateSignMask(environment, baseOffset, value, size, instructions);
        long offset = baseOffset + (long)instructions.size() - (long)oldInstructionsSize;
        String toggledSign = environment.getNextVariableString();
        String absValue = environment.getNextVariableString();
        instructions.add(ReilHelpers.createXor(offset, size, value, size, signMask.second(), size, toggledSign));
        instructions.add(ReilHelpers.createSub(offset + 1L, size, toggledSign, size, signMask.second(), size, absValue));
        return new Pair<String, String>(signMask.first(), absValue);
    }

    public static void generateDelayBranch(List<ReilInstruction> instructions, long baseOffset, OperandSize conditionSize, String conditionOperand, OperandSize targetSize, IOperandTreeNode targetOperand) {
        Helpers.generateDelayBranchInternal(instructions, baseOffset, conditionSize, conditionOperand, targetSize, targetOperand, new String[]{"branch_delay", "true"});
    }

    public static void generateDelayBranchLikely(List<ReilInstruction> instructions, long baseOffset, OperandSize conditionSize, String conditionOperand, OperandSize targetSize, IOperandTreeNode targetOperand) {
        Helpers.generateDelayBranchInternal(instructions, baseOffset, conditionSize, conditionOperand, targetSize, targetOperand, new String[]{"branch_delay_true", "true"});
    }

    public static int getRegisterSize() {
        return registerSize;
    }

    public static String getTRegister() {
        return "$t8";
    }

    public static void setRegisterSize(int size) {
        registerSize = size;
    }

    public static void signedMul(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, OperandSize firstOperandSize, String firstOperand, OperandSize secondOperandSize, String secondOperand, OperandSize resultOperandSize, String resultOperand) {
        String xoredResult = environment.getNextVariableString();
        String multResult = environment.getNextVariableString();
        String toggleMask = environment.getNextVariableString();
        String xoredSigns = environment.getNextVariableString();
        long baseOffset = offset;
        Pair<String, String> abs1 = Helpers.generateAbs(environment, baseOffset, firstOperand, firstOperandSize, instructions);
        Pair<String, String> abs2 = Helpers.generateAbs(environment, baseOffset, secondOperand, secondOperandSize, instructions);
        String firstAbs = abs1.second();
        String secondAbs = abs2.second();
        instructions.add(ReilHelpers.createMul(baseOffset++, firstOperandSize, firstAbs, secondOperandSize, secondAbs, resultOperandSize, multResult));
        instructions.add(ReilHelpers.createXor(baseOffset++, firstOperandSize, abs1.first(), secondOperandSize, abs2.first(), firstOperandSize, xoredSigns));
        instructions.add(ReilHelpers.createSub(baseOffset++, firstOperandSize, "0", firstOperandSize, xoredSigns, resultOperandSize, toggleMask));
        instructions.add(ReilHelpers.createXor(baseOffset++, resultOperandSize, toggleMask, resultOperandSize, multResult, resultOperandSize, xoredResult));
        instructions.add(ReilHelpers.createAdd(baseOffset, resultOperandSize, xoredResult, firstOperandSize, xoredSigns, resultOperandSize, resultOperand));
    }

    public static void signedSub(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String firstOperand, String secondOperand, String resultOperand, String trueResult) {
        String tmpResult = environment.getNextVariableString();
        String twoComplementfirstOperand = environment.getNextVariableString();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        OperandSize bt2 = OperandSize.BYTE;
        long baseOffset = offset;
        instructions.add(ReilHelpers.createXor(baseOffset++, dw, firstOperand, dw, String.valueOf(0xFFFFFFFFL), dw, twoComplementfirstOperand));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, twoComplementfirstOperand, dw, secondOperand, qw, tmpResult));
        instructions.add(ReilHelpers.createAdd(baseOffset++, qw, tmpResult, bt2, String.valueOf(1L), qw, trueResult));
        instructions.add(ReilHelpers.createAnd(baseOffset, qw, trueResult, dw, String.valueOf(0xFFFFFFFFL), dw, resultOperand));
    }
}

