/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTree;
import java.util.List;

public class DsllTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "dsll");
        List<? extends IOperandTree> operands = instruction.getOperands();
        String rd = operands.get(0).getRootNode().getChildren().get(0).getValue();
        String rt = operands.size() == 2 ? rd : operands.get(1).getRootNode().getChildren().get(0).getValue();
        String sa = operands.size() == 2 ? operands.get(1).getRootNode().getChildren().get(0).getValue() : operands.get(2).getRootNode().getChildren().get(0).getValue();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        OperandSize qw = OperandSize.QWORD;
        OperandSize ow = OperandSize.OWORD;
        String shiftedValue = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(offset++, qw, rt, qw, sa, ow, shiftedValue));
        instructions.add(ReilHelpers.createAnd(offset++, ow, shiftedValue, qw, String.valueOf(-1L), qw, rd));
    }
}

