/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class DmultuTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "dmultu");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize qw = OperandSize.QWORD;
        OperandSize ow = OperandSize.OWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String tempLoResult = environment.getNextVariableString();
        String tempHiResult = environment.getNextVariableString();
        instructions.add(ReilHelpers.createMul(offset++, qw, sourceRegister1, qw, sourceRegister2, ow, tempLoResult));
        instructions.add(ReilHelpers.createAnd(offset++, ow, tempLoResult, qw, String.valueOf(-1L), qw, "LO"));
        instructions.add(ReilHelpers.createBsh(offset++, ow, tempLoResult, qw, String.valueOf(-32L), qw, tempHiResult));
        instructions.add(ReilHelpers.createAnd(offset++, ow, tempHiResult, qw, String.valueOf(-1L), qw, "HI"));
    }
}

