/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class DivuTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "divu");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize dw = OperandSize.DWORD;
        String quotient = environment.getNextVariableString();
        String reminder = environment.getNextVariableString();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        instructions.add(ReilHelpers.createDiv(offset++, dw, sourceRegister1, dw, sourceRegister2, dw, quotient));
        instructions.add(ReilHelpers.createMod(offset++, dw, sourceRegister1, dw, sourceRegister2, dw, reminder));
        instructions.add(ReilHelpers.createStr(offset++, dw, quotient, dw, "LO"));
        instructions.add(ReilHelpers.createStr(offset, dw, reminder, dw, "HI"));
    }
}

