/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class DdivuTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "ddivu");
        String sourceRegister1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        OperandSize qw = OperandSize.QWORD;
        String quotient = environment.getNextVariableString();
        String reminder = environment.getNextVariableString();
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        instructions.add(ReilHelpers.createDiv(offset++, qw, sourceRegister1, qw, sourceRegister2, qw, quotient));
        instructions.add(ReilHelpers.createMod(offset++, qw, sourceRegister1, qw, sourceRegister2, qw, reminder));
        instructions.add(ReilHelpers.createStr(offset++, qw, quotient, qw, "LO"));
        instructions.add(ReilHelpers.createStr(offset, qw, reminder, qw, "HI"));
    }
}

