/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class DaddiuTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "daddiu");
        String targetRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        String sourceImmediate = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue();
        OperandSize qw = OperandSize.QWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String temporaryResult = environment.getNextVariableString();
        String sourceImmediateSignExtended = SignExtendGenerator.extend16BitTo64(offset, environment, sourceImmediate, instructions);
        instructions.add(ReilHelpers.createAdd(offset++, qw, sourceRegister, qw, sourceImmediateSignExtended, qw, temporaryResult));
        instructions.add(ReilHelpers.createAnd(offset, qw, temporaryResult, qw, String.valueOf(-1L), qw, targetRegister));
    }
}

