/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.mips;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.IInstructionTranslator;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.mips.SignExtendGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class DaddiTranslator
implements IInstructionTranslator {
    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        long baseOffset;
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "daddi");
        String targetRegister = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getValue();
        String sourceRegister = instruction.getOperands().get(1).getRootNode().getChildren().get(0).getValue();
        String sourceImmediate = instruction.getOperands().get(2).getRootNode().getChildren().get(0).getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        OperandSize ow = OperandSize.OWORD;
        long offset = baseOffset = ReilHelpers.toReilAddress(instruction.getAddress()).toLong();
        String temporaryResult = environment.getNextVariableString();
        String bit63 = environment.getNextVariableString();
        String bit64 = environment.getNextVariableString();
        String jumpCondition = environment.getNextVariableString();
        String sourceImmediateSignExtended = SignExtendGenerator.extend16BitTo64(offset, environment, sourceImmediate, instructions);
        instructions.add(ReilHelpers.createAdd(offset++, qw, sourceRegister, qw, sourceImmediateSignExtended, ow, temporaryResult));
        instructions.add(ReilHelpers.createBsh(offset++, ow, temporaryResult, dw, String.valueOf(-63L), bt2, bit63));
        instructions.add(ReilHelpers.createBsh(offset++, ow, temporaryResult, dw, String.valueOf(-64L), bt2, bit64));
        instructions.add(ReilHelpers.createXor(offset++, bt2, bit63, bt2, bit64, bt2, jumpCondition));
        String jmpGoal = String.format("%d.%d", instruction.getAddress().toLong(), instructions.size() + 2);
        instructions.add(ReilHelpers.createJcc(offset++, bt2, jumpCondition, dw, jmpGoal, new String[0]));
        instructions.add(ReilHelpers.createAnd(offset++, ow, temporaryResult, qw, String.valueOf(-1L), qw, targetRegister));
        instructions.add(ReilHelpers.createNop(offset));
    }
}

