/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMBSubTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode operand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode operand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode operand3 = instruction.getOperands().size() == 3 ? instruction.getOperands().get(2).getRootNode().getChildren().get(0) : null;
        String sourceRegister1 = operand1.getValue();
        String sourceRegister2 = operand2.getValue();
        String sourceRegister3 = instruction.getOperands().size() == 3 ? operand3.getValue() : null;
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        if (instruction.getOperands().size() == 3) {
            if (operand1.getType() == ExpressionType.REGISTER && operand2.getType() == ExpressionType.REGISTER && operand3.getType() == ExpressionType.REGISTER) {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister2, dw, sourceRegister3, qw, tmpVar1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
                if (instruction.getMnemonic().contains("SUBS")) {
                    instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, wd, String.valueOf(-31L), bt2, "N"));
                    instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, bt2, "Z"));
                    instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar1, wd, String.valueOf(-31L), bt2, tmpVar2));
                    instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar2, bt2, String.valueOf(1L), bt2, tmpVar3));
                    instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar3, bt2, "C"));
                    Helpers.subOverflow(baseOffset, environment, instruction, instructions, dw, sourceRegister2, dw, sourceRegister3, bt2, tmpVar2, "V", 32L);
                }
            } else if (operand1.getType() == ExpressionType.REGISTER && operand2.getType() == ExpressionType.REGISTER && operand3.getType() == ExpressionType.IMMEDIATE_INTEGER) {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister2, dw, sourceRegister3, qw, tmpVar1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
                if (instruction.getMnemonic().contains("SUBS")) {
                    instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, wd, String.valueOf(-31L), bt2, "N"));
                    instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, bt2, "Z"));
                    instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar1, wd, String.valueOf(-31L), bt2, tmpVar2));
                    instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar2, bt2, String.valueOf(1L), bt2, tmpVar3));
                    instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar3, bt2, "C"));
                    Helpers.subOverflow(baseOffset, environment, instruction, instructions, dw, sourceRegister2, dw, sourceRegister3, bt2, tmpVar2, "V", 32L);
                }
            }
        } else if (instruction.getOperands().size() == 2) {
            if (sourceRegister2.equalsIgnoreCase("SP")) {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister1, dw, sourceRegister2, qw, tmpVar1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
            } else {
                instructions.add(ReilHelpers.createSub(baseOffset++, dw, sourceRegister1, dw, sourceRegister2, qw, tmpVar1));
                instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar1, dw, String.valueOf(0xFFFFFFFFL), dw, sourceRegister1));
                if (instruction.getMnemonic().contains("SUBS")) {
                    instructions.add(ReilHelpers.createBsh(baseOffset++, dw, sourceRegister1, wd, String.valueOf(-31L), bt2, "N"));
                    instructions.add(ReilHelpers.createBisz(baseOffset++, dw, sourceRegister1, bt2, "Z"));
                    instructions.add(ReilHelpers.createBsh(baseOffset++, qw, tmpVar1, wd, String.valueOf(-31L), bt2, tmpVar2));
                    instructions.add(ReilHelpers.createAnd(baseOffset++, bt2, tmpVar2, bt2, String.valueOf(1L), bt2, tmpVar3));
                    instructions.add(ReilHelpers.createBisz(baseOffset++, bt2, tmpVar3, bt2, "C"));
                    Helpers.subOverflow(baseOffset, environment, instruction, instructions, dw, sourceRegister1, dw, sourceRegister2, bt2, tmpVar2, "V", 32L);
                }
            }
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "SUB");
        this.translateAll(environment, instruction, "SUB", instructions);
    }
}

