/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import java.util.List;

public class THUMBPopTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        int registerListLength = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().size();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpAddress = environment.getNextVariableString();
        String tmpValue = environment.getNextVariableString();
        String jmpTarget = environment.getNextVariableString();
        instructions.add(ReilHelpers.createStr(baseOffset++, dw, "SP", dw, tmpAddress));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, String.valueOf(4 * registerListLength), dw, tmpAddress, dw, "SP"));
        for (int i2 = 0; i2 < registerListLength; ++i2) {
            if (instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().get(i2).getValue().equalsIgnoreCase("PC")) {
                instructions.add(ReilHelpers.createLdm(baseOffset++, dw, tmpAddress, dw, tmpValue));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpValue, bt2, String.valueOf(1), bt2, "T"));
                instructions.add(ReilHelpers.createAnd(baseOffset++, dw, tmpValue, dw, String.valueOf(0xFFFFFFFEL), dw, jmpTarget));
                instructions.add(ReilHelpers.createJcc(baseOffset++, dw, String.valueOf(1L), dw, jmpTarget, new String[0]));
                continue;
            }
            instructions.add(ReilHelpers.createLdm(baseOffset++, dw, tmpAddress, dw, instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().get(i2).getValue()));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpAddress, bt2, String.valueOf(4L), dw, tmpAddress));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "POP");
        this.translateAll(environment, instruction, "POP", instructions);
    }
}

