/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMBMvnTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String targetRegister = registerOperand1.getValue();
        String sourceRegister = registerOperand2.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize wd = OperandSize.WORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        instructions.add(ReilHelpers.createXor(baseOffset++, dw, sourceRegister, dw, String.valueOf(0xFFFFFFFFL), dw, targetRegister));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dw, targetRegister, wd, String.valueOf(-31), bt2, "N"));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dw, targetRegister, bt2, "Z"));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "MVN");
        this.translateAll(environment, instruction, "MVN", instructions);
    }
}

