/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.ARMFlagSettingHelper;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMBAddTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode operand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode operand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode operand3 = instruction.getOperands().size() == 3 ? instruction.getOperands().get(2).getRootNode().getChildren().get(0) : null;
        String resultRegister = operand1.getValue();
        String sourceRegister1 = instruction.getOperands().size() == 3 ? operand2.getValue() : operand1.getValue();
        String sourceRegister2 = instruction.getOperands().size() == 3 ? operand3.getValue() : operand2.getValue();
        OperandSize dw = OperandSize.DWORD;
        OperandSize qw = OperandSize.QWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String tmpVar2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dw, sourceRegister1, dw, sourceRegister2, qw, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qw, tmpVar2, dw, String.valueOf(0xFFFFFFFFL), dw, resultRegister));
        if (instruction.getMnemonic().contains("ADDS")) {
            ARMFlagSettingHelper.setThumbAddFlags(environment, instructions, baseOffset, qw, tmpVar2, dw, resultRegister, dw, sourceRegister1, dw, sourceRegister2);
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "ADD");
        this.translateAll(environment, instruction, "ADD", instructions);
    }
}

