/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeTwoGenerator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class THUMB2STRDTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        Boolean writeBack = instruction.getOperands().get(0).getRootNode().getChildren().get(0).getChildren().size() == 1;
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        IOperandTreeNode rootNode = instruction.getOperands().get(2).getRootNode();
        String registerNodeValue1 = registerOperand1.getValue();
        String registerNodeValue2 = registerOperand2.getValue();
        OperandSize bt2 = OperandSize.BYTE;
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        Pair<String, String> resultPair = AddressingModeTwoGenerator.generate(baseOffset, environment, instruction, instructions, rootNode);
        String tmpAddress = resultPair.first();
        String tmpAddress2 = environment.getNextVariableString();
        int registerNum = Helpers.getRegisterIndex(registerNodeValue1);
        if (registerNum % 2 == 0 && registerNum != 14) {
            instructions.add(ReilHelpers.createStm(baseOffset++, dw, registerNodeValue1, dw, tmpAddress));
            instructions.add(ReilHelpers.createAdd(baseOffset++, dw, tmpAddress, bt2, String.valueOf(4), dw, tmpAddress2));
            instructions.add(ReilHelpers.createStm(baseOffset++, dw, registerNodeValue2, dw, tmpAddress2));
            if (writeBack.booleanValue()) {
                instructions.add(ReilHelpers.createStr(baseOffset++, dw, tmpAddress2, dw, registerNodeValue1));
            }
        } else {
            instructions.add(ReilHelpers.createUnknown(baseOffset++));
        }
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "STR");
        this.translateAll(environment, instruction, "STR", instructions);
    }
}

