/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.Helpers;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import java.util.List;

public class THUMB2RBITTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode registerOperand2 = instruction.getOperands().get(1).getRootNode().getChildren().get(0);
        String sourceRegister = registerOperand2.getValue();
        String destinationRegister = registerOperand1.getValue();
        long baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        OperandSize dw = OperandSize.DWORD;
        String temporaryRegister = Helpers.reverseUnsignedInteger(environment, baseOffset, sourceRegister, instructions);
        baseOffset = ReilHelpers.nextReilAddress(instruction, instructions);
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, temporaryRegister, dw, String.valueOf(0xFFFFFFFFL), dw, destinationRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "RBIT");
        this.translateAll(environment, instruction, "RBIT", instructions);
    }
}

