/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.common.base.Preconditions;
import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.zylib.disassembly.ExpressionType;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public final class AddressingModeOneGenerator {
    private static final OperandSize byteSize = OperandSize.BYTE;
    private static final OperandSize wordSize = OperandSize.WORD;
    private static final OperandSize dWordSize = OperandSize.DWORD;
    private static final OperandSize qWordSize = OperandSize.QWORD;
    private static String bitMaskAllBitsSet = String.valueOf(0xFFFFFFFFL);
    private static String bitMaskHighestBitSet = String.valueOf(0x80000000L);
    private static String oneSet = String.valueOf(1L);
    private static String zeroSet = String.valueOf(0L);
    private static String thirtyOneSet = String.valueOf(31L);
    private static String minusThirtyOneSet = String.valueOf(-31L);
    private static String notThirtyOneSet = String.valueOf(-32L);

    private AddressingModeOneGenerator() {
    }

    private static Pair<String, String> immediateROR(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String immediateNodeValue1, String immediateNodeValue2) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        long baseOffset = offset;
        long l2 = baseOffset++;
        String string2 = String.valueOf(immediateNodeValue2);
        instructions.add(ReilHelpers.createBsh(l2, dWordSize, immediateNodeValue1, wordSize, string2.length() != 0 ? "-".concat(string2) : new String("-"), dWordSize, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, immediateNodeValue1, wordSize, String.valueOf(32 - Integer.decode(immediateNodeValue2)), qWordSize, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, tmpVar1, qWordSize, tmpVar2, qWordSize, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qWordSize, tmpVar3, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBsh(baseOffset++, qWordSize, tmpVar3, dWordSize, minusThirtyOneSet, dWordSize, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar4, dWordSize, oneSet, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    private static Pair<String, String> immediateRotateZero(String immediateNodeValue) {
        return new Pair<String, String>(immediateNodeValue, "C");
    }

    private static Pair<String, String> register(String registerNodeValue) {
        return new Pair<String, String>(registerNodeValue, "C");
    }

    private static Pair<String, String> rorImmediate(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        long baseOffset = offset;
        if (immediateNodeValue.equals("0")) {
            String tmpVar1 = environment.getNextVariableString();
            String tmpVar2 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, byteSize, "C", wordSize, thirtyOneSet, dWordSize, tmpVar1));
            long l2 = baseOffset++;
            String string2 = String.valueOf(String.valueOf(1));
            instructions.add(ReilHelpers.createBsh(l2, dWordSize, registerNodeValue, byteSize, string2.length() != 0 ? "-".concat(string2) : new String("-"), dWordSize, tmpVar2));
            instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, tmpVar1, dWordSize, tmpVar2, dWordSize, shifterOperand));
            instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue, byteSize, String.valueOf(1), byteSize, shifterCarryOut));
            return new Pair<String, String>(shifterOperand, shifterCarryOut);
        }
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        long l3 = baseOffset++;
        String string3 = String.valueOf(Integer.decode(immediateNodeValue));
        instructions.add(ReilHelpers.createBsh(l3, dWordSize, registerNodeValue, wordSize, new StringBuilder(1 + String.valueOf(string3).length()).append("-").append(string3).toString(), dWordSize, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, wordSize, String.valueOf(32 - Integer.decode(immediateNodeValue)), qWordSize, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, tmpVar1, qWordSize, tmpVar2, qWordSize, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qWordSize, tmpVar3, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, dWordSize, String.valueOf(-(Integer.decode(immediateNodeValue) - 1)), dWordSize, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar4, byteSize, String.valueOf(1), byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> asrImmediate(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        long baseOffset = offset;
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        if (immediateNodeValue.equals("0")) {
            String tmpVar1 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, wordSize, thirtyOneSet, byteSize, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, tmpVar1, byteSize, oneSet, byteSize, shifterCarryOut));
            instructions.add(ReilHelpers.createSub(baseOffset++, byteSize, shifterCarryOut, byteSize, String.valueOf(1), dWordSize, shifterOperand));
            return new Pair<String, String>(shifterOperand, shifterCarryOut);
        }
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAdd(baseOffset++, dWordSize, registerNodeValue, dWordSize, bitMaskHighestBitSet, qWordSize, tmpVar1));
        long l2 = baseOffset++;
        String string2 = String.valueOf(immediateNodeValue);
        instructions.add(ReilHelpers.createBsh(l2, qWordSize, tmpVar1, wordSize, string2.length() != 0 ? "-".concat(string2) : new String("-"), dWordSize, tmpVar2));
        long l3 = baseOffset++;
        String string3 = String.valueOf(immediateNodeValue);
        instructions.add(ReilHelpers.createBsh(l3, dWordSize, bitMaskHighestBitSet, wordSize, string3.length() != 0 ? "-".concat(string3) : new String("-"), dWordSize, tmpVar3));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, tmpVar2, dWordSize, tmpVar3, qWordSize, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qWordSize, tmpVar4, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, dWordSize, String.valueOf(-(Integer.decode(immediateNodeValue) - 1)), wordSize, tmpVar5));
        instructions.add(ReilHelpers.createAnd(baseOffset++, wordSize, tmpVar5, byteSize, oneSet, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> asrRegister(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        String isZeroCondition = environment.getNextVariableString();
        String isLessCondition = environment.getNextVariableString();
        String isGtEqCondition = environment.getNextVariableString();
        String shifterCarryOutTmp1 = environment.getNextVariableString();
        String shifterCarryOutTmp2 = environment.getNextVariableString();
        String shifterCarryOutTmp3 = environment.getNextVariableString();
        String shifterCarryOutTmp4 = environment.getNextVariableString();
        String shifterOperandTmp1 = environment.getNextVariableString();
        String shifterOperandTmp2 = environment.getNextVariableString();
        String shifterOperandTmp3 = environment.getNextVariableString();
        String shifterOperandTmp4 = environment.getNextVariableString();
        String tmpRsRegister = environment.getNextVariableString();
        String negativeTmpRsRegister = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        String tmpVar8 = environment.getNextVariableString();
        String tmpVar9 = environment.getNextVariableString();
        String tmpVar10 = environment.getNextVariableString();
        String tmpVar11 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue2, dWordSize, String.valueOf(255L), dWordSize, tmpRsRegister));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, zeroSet, dWordSize, tmpRsRegister, dWordSize, negativeTmpRsRegister));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpRsRegister, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, "C", byteSize, isZeroCondition, byteSize, shifterCarryOutTmp1));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, String.valueOf(0), byteSize, isZeroCondition, dWordSize, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar1, dWordSize, registerNodeValue2, dWordSize, shifterOperandTmp1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpRsRegister, dWordSize, String.valueOf(0xFFFFFFE0L), dWordSize, tmpVar2));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar2, byteSize, isLessCondition));
        instructions.add(ReilHelpers.createAdd(baseOffset++, dWordSize, registerNodeValue1, dWordSize, bitMaskHighestBitSet, dWordSize, tmpVar3));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, tmpVar3, dWordSize, negativeTmpRsRegister, dWordSize, tmpVar4));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, bitMaskHighestBitSet, dWordSize, negativeTmpRsRegister, dWordSize, tmpVar5));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, tmpVar4, dWordSize, tmpVar5, dWordSize, tmpVar6));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, zeroSet, byteSize, isLessCondition, dWordSize, tmpVar7));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar6, dWordSize, tmpVar7, dWordSize, shifterOperandTmp2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, tmpRsRegister, byteSize, oneSet, dWordSize, tmpVar8));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, zeroSet, dWordSize, tmpVar8, dWordSize, tmpVar8));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpVar8, dWordSize, tmpVar9));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar9, byteSize, isLessCondition, byteSize, shifterCarryOutTmp2));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, isZeroCondition, byteSize, isLessCondition, byteSize, tmpVar10));
        instructions.add(ReilHelpers.createBisz(baseOffset++, byteSize, tmpVar10, byteSize, isGtEqCondition));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, minusThirtyOneSet, byteSize, tmpVar11));
        instructions.add(ReilHelpers.createSub(baseOffset++, byteSize, zeroSet, byteSize, isGtEqCondition, dWordSize, shifterOperandTmp3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, tmpVar11, byteSize, isGtEqCondition, byteSize, shifterCarryOutTmp3));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp1, byteSize, shifterCarryOutTmp2, byteSize, shifterCarryOutTmp4));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp3, byteSize, shifterCarryOutTmp4, byteSize, shifterCarryOut));
        instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, shifterOperandTmp1, dWordSize, shifterOperandTmp2, dWordSize, shifterOperandTmp4));
        instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, shifterOperandTmp3, dWordSize, shifterOperandTmp4, dWordSize, shifterOperand));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> lslImmediate(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        long baseOffset = offset;
        if (immediateNodeValue.equals("0")) {
            return new Pair<String, String>(registerNodeValue, "C");
        }
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, wordSize, immediateNodeValue, qWordSize, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qWordSize, tmpVar1, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, wordSize, String.valueOf(-(32 - Integer.decode(immediateNodeValue))), dWordSize, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar2, byteSize, oneSet, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> lslRegister(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        long baseOffset = offset;
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        String isZeroCondition = environment.getNextVariableString();
        String shifterCarryOutTmp1 = environment.getNextVariableString();
        String shifterCarryOutTmp2 = environment.getNextVariableString();
        String shifterCarryOutTmp3 = environment.getNextVariableString();
        String shifterCarryOutTmp4 = environment.getNextVariableString();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue2, dWordSize, String.valueOf(255L), dWordSize, tmpVar1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpVar1, qWordSize, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qWordSize, tmpVar2, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar1, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, isZeroCondition, byteSize, "C", byteSize, shifterCarryOutTmp1));
        instructions.add(ReilHelpers.createXor(baseOffset++, dWordSize, tmpVar1, wordSize, String.valueOf(32L), dWordSize, tmpVar3));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar3, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue1, dWordSize, oneSet, byteSize, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, isZeroCondition, byteSize, tmpVar4, byteSize, shifterCarryOutTmp2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar1, dWordSize, notThirtyOneSet, dWordSize, tmpVar5));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar5, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, String.valueOf(32L), dWordSize, tmpVar1, dWordSize, tmpVar6));
        long l2 = baseOffset++;
        String string2 = String.valueOf(tmpVar6);
        instructions.add(ReilHelpers.createBsh(l2, dWordSize, registerNodeValue1, dWordSize, string2.length() != 0 ? "-".concat(string2) : new String("-"), byteSize, tmpVar7));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, isZeroCondition, byteSize, tmpVar7, byteSize, shifterCarryOutTmp3));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp1, byteSize, shifterCarryOutTmp2, byteSize, shifterCarryOutTmp4));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp3, byteSize, shifterCarryOutTmp4, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> lsrImmediate(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue, String immediateNodeValue) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        long baseOffset = offset;
        if (immediateNodeValue.equals("0")) {
            String tmpVar1 = environment.getNextVariableString();
            instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, wordSize, minusThirtyOneSet, wordSize, tmpVar1));
            instructions.add(ReilHelpers.createAnd(baseOffset++, wordSize, tmpVar1, byteSize, oneSet, byteSize, shifterCarryOut));
            return new Pair<String, String>(String.valueOf(0), shifterCarryOut);
        }
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        long l2 = baseOffset++;
        String string2 = String.valueOf(immediateNodeValue);
        instructions.add(ReilHelpers.createBsh(l2, dWordSize, registerNodeValue, wordSize, string2.length() != 0 ? "-".concat(string2) : new String("-"), qWordSize, tmpVar1));
        instructions.add(ReilHelpers.createAnd(baseOffset++, qWordSize, tmpVar1, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue, wordSize, String.valueOf(-(Integer.decode(immediateNodeValue) - 1)), dWordSize, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar2, byteSize, oneSet, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> lsrRegister(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar11 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        String isZeroCondition = environment.getNextVariableString();
        String shifterCarryOutTmp1 = environment.getNextVariableString();
        String shifterCarryOutTmp2 = environment.getNextVariableString();
        String shifterCarryOutTmp3 = environment.getNextVariableString();
        String shifterCarryOutTmp4 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue2, dWordSize, String.valueOf(255L), dWordSize, tmpVar1));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, String.valueOf(0), dWordSize, tmpVar1, dWordSize, tmpVar11));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpVar11, dWordSize, tmpVar2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar2, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar11, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, isZeroCondition, byteSize, "C", byteSize, shifterCarryOutTmp1));
        instructions.add(ReilHelpers.createXor(baseOffset++, dWordSize, tmpVar11, wordSize, String.valueOf(32L), dWordSize, tmpVar3));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar3, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, thirtyOneSet, byteSize, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, isZeroCondition, byteSize, tmpVar4, byteSize, shifterCarryOutTmp2));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar11, dWordSize, notThirtyOneSet, dWordSize, tmpVar5));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpVar5, byteSize, isZeroCondition));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, tmpVar11, dWordSize, oneSet, dWordSize, tmpVar6));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, zeroSet, dWordSize, tmpVar6, dWordSize, tmpVar6));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpVar6, byteSize, tmpVar7));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, isZeroCondition, byteSize, tmpVar7, byteSize, shifterCarryOutTmp3));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp1, byteSize, shifterCarryOutTmp2, byteSize, shifterCarryOutTmp4));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp3, byteSize, shifterCarryOutTmp4, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> rorRegister(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue1, String registerNodeValue2) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        String tmpRsFour = environment.getNextVariableString();
        String tmpRsFourNegative = environment.getNextVariableString();
        String tmpRsSeven = environment.getNextVariableString();
        String isZeroConditionFour = environment.getNextVariableString();
        String isNotZeroConditionFour = environment.getNextVariableString();
        String isZeroConditionSeven = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        String tmpVar4 = environment.getNextVariableString();
        String tmpVar5 = environment.getNextVariableString();
        String tmpVar6 = environment.getNextVariableString();
        String tmpVar7 = environment.getNextVariableString();
        String tmpVar8 = environment.getNextVariableString();
        String shifterCarryOutTmp1 = environment.getNextVariableString();
        String shifterCarryOutTmp2 = environment.getNextVariableString();
        String shifterCarryOutTmp3 = environment.getNextVariableString();
        String shifterCarryOutTmp4 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue2, dWordSize, String.valueOf(255L), dWordSize, tmpRsSeven));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpRsSeven, byteSize, isZeroConditionSeven));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpRsSeven, dWordSize, String.valueOf(31L), dWordSize, tmpRsFour));
        instructions.add(ReilHelpers.createBisz(baseOffset++, dWordSize, tmpRsFour, byteSize, isZeroConditionFour));
        instructions.add(ReilHelpers.createBisz(baseOffset++, byteSize, isZeroConditionFour, byteSize, isNotZeroConditionFour));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, zeroSet, dWordSize, tmpRsFour, dWordSize, tmpRsFourNegative));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpRsFourNegative, dWordSize, tmpVar1));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, String.valueOf(32L), dWordSize, tmpRsFour, dWordSize, tmpVar2));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpVar2, dWordSize, tmpVar3));
        instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, tmpVar1, dWordSize, tmpVar3, dWordSize, tmpVar4));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar4, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, "C", byteSize, isZeroConditionSeven, byteSize, shifterCarryOutTmp1));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, minusThirtyOneSet, byteSize, tmpVar5));
        instructions.add(ReilHelpers.createAnd(baseOffset++, byteSize, tmpVar5, byteSize, isZeroConditionFour, byteSize, shifterCarryOutTmp2));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, tmpRsFour, byteSize, oneSet, dWordSize, tmpVar6));
        instructions.add(ReilHelpers.createSub(baseOffset++, dWordSize, zeroSet, dWordSize, tmpVar6, dWordSize, tmpVar7));
        instructions.add(ReilHelpers.createBsh(baseOffset++, dWordSize, registerNodeValue1, dWordSize, tmpVar7, dWordSize, tmpVar8));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar8, byteSize, isNotZeroConditionFour, byteSize, shifterCarryOutTmp3));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp1, byteSize, shifterCarryOutTmp2, byteSize, shifterCarryOutTmp4));
        instructions.add(ReilHelpers.createOr(baseOffset++, byteSize, shifterCarryOutTmp3, byteSize, shifterCarryOutTmp4, byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    protected static Pair<String, String> rrxRegister(long offset, ITranslationEnvironment environment, List<ReilInstruction> instructions, String registerNodeValue) {
        String shifterOperand = environment.getNextVariableString();
        String shifterCarryOut = environment.getNextVariableString();
        String tmpVar1 = environment.getNextVariableString();
        String tmpVar2 = environment.getNextVariableString();
        String tmpVar3 = environment.getNextVariableString();
        long baseOffset = offset;
        instructions.add(ReilHelpers.createBsh(baseOffset++, byteSize, "C", wordSize, thirtyOneSet, dWordSize, tmpVar1));
        long l2 = baseOffset++;
        String string2 = String.valueOf(oneSet);
        instructions.add(ReilHelpers.createBsh(l2, dWordSize, registerNodeValue, byteSize, string2.length() != 0 ? "-".concat(string2) : new String("-"), dWordSize, tmpVar2));
        instructions.add(ReilHelpers.createOr(baseOffset++, dWordSize, tmpVar1, dWordSize, tmpVar2, dWordSize, tmpVar3));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, tmpVar3, dWordSize, bitMaskAllBitsSet, dWordSize, shifterOperand));
        instructions.add(ReilHelpers.createAnd(baseOffset++, dWordSize, registerNodeValue, byteSize, String.valueOf(1), byteSize, shifterCarryOut));
        return new Pair<String, String>(shifterOperand, shifterCarryOut);
    }

    public static Pair<String, String> generate(long baseOffset, ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions, IOperandTreeNode rootNode) throws InternalTranslationException {
        Preconditions.checkNotNull(environment, "Error: Argument environment can't be null");
        Preconditions.checkNotNull(instruction, "Error: Argument instruction can't be null");
        Preconditions.checkNotNull(instructions, "Error: Argument instructions can't be null");
        if (rootNode.getChildren().get(0).getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return AddressingModeOneGenerator.immediateRotateZero(rootNode.getChildren().get(0).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("ROR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return AddressingModeOneGenerator.immediateROR(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.REGISTER) {
            return AddressingModeOneGenerator.register(rootNode.getChildren().get(0).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("LSL") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return AddressingModeOneGenerator.lslImmediate(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("LSL") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
            return AddressingModeOneGenerator.lslRegister(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("LSR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return AddressingModeOneGenerator.lsrImmediate(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("LSR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
            return AddressingModeOneGenerator.lsrRegister(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("ASR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return AddressingModeOneGenerator.asrImmediate(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("ASR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
            return AddressingModeOneGenerator.asrRegister(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("ROR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.IMMEDIATE_INTEGER) {
            return AddressingModeOneGenerator.rorImmediate(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("ROR") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER && rootNode.getChildren().get(0).getChildren().get(1).getType() == ExpressionType.REGISTER) {
            return AddressingModeOneGenerator.rorRegister(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue(), rootNode.getChildren().get(0).getChildren().get(1).getValue());
        }
        if (rootNode.getChildren().get(0).getType() == ExpressionType.OPERATOR && rootNode.getChildren().get(0).getValue().equals("RRX") && rootNode.getChildren().get(0).getChildren().get(0).getType() == ExpressionType.REGISTER) {
            return AddressingModeOneGenerator.rrxRegister(baseOffset, environment, instructions, rootNode.getChildren().get(0).getChildren().get(0).getValue());
        }
        String string2 = String.valueOf(instruction.getMnemonic());
        String string3 = String.valueOf(instruction.getAddress().toString());
        throw new InternalTranslationException(new StringBuilder(54 + String.valueOf(string2).length() + String.valueOf(string3).length()).append("Error: AddressOperandTypeOne OperandTree is not valid").append(string2).append(" ").append(string3).toString());
    }
}

