/*
 * Decompiled with CFR 0.152.
 */
package com.google.security.zynamics.reil.translators.arm;

import com.google.security.zynamics.reil.OperandSize;
import com.google.security.zynamics.reil.ReilHelpers;
import com.google.security.zynamics.reil.ReilInstruction;
import com.google.security.zynamics.reil.translators.ITranslationEnvironment;
import com.google.security.zynamics.reil.translators.InternalTranslationException;
import com.google.security.zynamics.reil.translators.TranslationHelpers;
import com.google.security.zynamics.reil.translators.arm.ARMBaseTranslator;
import com.google.security.zynamics.reil.translators.arm.AddressingModeOneGenerator;
import com.google.security.zynamics.zylib.disassembly.IInstruction;
import com.google.security.zynamics.zylib.disassembly.IOperandTreeNode;
import com.google.security.zynamics.zylib.general.Pair;
import java.util.List;

public class ARMUxtbTranslator
extends ARMBaseTranslator {
    @Override
    protected void translateCore(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        IOperandTreeNode registerOperand1 = instruction.getOperands().get(0).getRootNode().getChildren().get(0);
        IOperandTreeNode shifter = instruction.getOperands().get(1).getRootNode();
        String targetRegister = registerOperand1.getValue();
        OperandSize dw = OperandSize.DWORD;
        long baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        Pair<String, String> shifterPair = AddressingModeOneGenerator.generate(baseOffset, environment, instruction, instructions, shifter);
        baseOffset = instruction.getAddress().toLong() * 256L + (long)instructions.size();
        String shifterOperand = shifterPair.first();
        instructions.add(ReilHelpers.createAnd(baseOffset++, dw, shifterOperand, dw, String.valueOf(255L), dw, targetRegister));
    }

    @Override
    public void translate(ITranslationEnvironment environment, IInstruction instruction, List<ReilInstruction> instructions) throws InternalTranslationException {
        TranslationHelpers.checkTranslationArguments(environment, instruction, instructions, "UXTB");
        this.translateAll(environment, instruction, "UXTB", instructions);
    }
}

